/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.message.email;

import com.bxm.warcar.MessageException;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import java.util.Properties;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class EmailMessageSender
implements MessageSender {
    private final JavaMailSender mailSender;

    public EmailMessageSender(String host, int port, String username, String password) {
        JavaMailSenderImpl mailSenderImpl = new JavaMailSenderImpl();
        mailSenderImpl.setHost(host);
        mailSenderImpl.setPort(port);
        mailSenderImpl.setUsername(username);
        mailSenderImpl.setPassword(password);
        Properties props = mailSenderImpl.getJavaMailProperties();
        props.put("mail.smtp.ssl.trust", host);
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.smtp.auth", "true");
        this.mailSender = mailSenderImpl;
    }

    @Override
    @Deprecated
    public boolean send(Message message) {
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setFrom(message.getFrom());
        mailMessage.setSubject(message.getSubject());
        mailMessage.setTo(message.getTos().toArray(new String[0]));
        mailMessage.setText(message.getContent());
        try {
            this.mailSender.send(mailMessage);
            return true;
        }
        catch (MailException e) {
            return false;
        }
    }

    @Override
    public void send2(Message message) throws MessageException {
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setFrom(message.getFrom());
        mailMessage.setSubject(message.getSubject());
        mailMessage.setTo(message.getTos().toArray(new String[0]));
        mailMessage.setText(message.getContent());
        try {
            this.mailSender.send(mailMessage);
        }
        catch (MailException e) {
            throw new MessageException(e, "");
        }
    }
}

