package com.bxm.warcar.micrometer.test.mq;

import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author allen
 * @date 2019/6/20
 * @since 1.0.0
 */
@RestController
@RequestMapping("/mq")
public class MqController {

    @Autowired(required = false)
    @Qualifier("alionsProducer")
    private Producer alions;

    @Autowired(required = false)
    @Qualifier("kafkaProducer")
    private Producer kafka;

    @RequestMapping("/post")
    public SendResult post() {
        return alions.send(new Message("AD_VIEWTICKET_NT", "Hello micrometer fo warcar.".getBytes()));
    }

    @RequestMapping("/postKafka")
    public SendResult postKafka() {
        return kafka.send(new Message("AD_VIEWTICKET_NT", "Hello micrometer fo warcar.".getBytes()));
    }
}
