package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.*;
import com.bxm.warcar.utils.UUIDHelper;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * 基于Redis的实现。
 * @author allen
 * @date 2019/10/17
 * @since 1.0.0
 */
public class RedisProducer implements Producer {

    private final RedisTemplate<String, Message> redisTemplate;

    public RedisProducer(RedisTemplate<String, Message> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public SendResult send(Message message) throws SendException {
        String topic = message.getTopic();
        String id = UUIDHelper.generate();
        message.setMsgId(id);
        Long row = redisTemplate.opsForList().rightPush(RedisConst.key(topic), message);
        if (null != row && row >= 1) {
            return new SendResult(id);
        }
        throw new SendException("0");
    }

    @Override
    public void start() {

    }

    @Override
    public void close() {

    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public Type getType() {
        return Type.Redis;
    }
}
