package com.bxm.warcar.mq.kafka;

import com.bxm.warcar.mq.*;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.collect.Lists;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

import java.util.Properties;

/**
 * <code>Beta</code>
 * @author allen
 * @since 1.0.0
 */
public class KafkaConsumer extends LifeCycle implements Consumer {

    private final Listener listener;
    private int consumeTimeOutInMillis = 100;
    private org.apache.kafka.clients.consumer.Consumer<String, byte[]> consumer;

    public KafkaConsumer(Properties properties, Listener listener) {
        this.listener = listener;
        this.consumer = new org.apache.kafka.clients.consumer.KafkaConsumer<String, byte[]>(properties);
    }

    @Override
    protected void doInit() {
        String topic = getMessageListener().getTopic();
        this.consumer.subscribe(Lists.newArrayList(topic));

        while (true) {
            ConsumerRecords<String, byte[]> records = this.consumer.poll(consumeTimeOutInMillis);
            for (ConsumerRecord<String, byte[]> record : records) {
                byte[] value = record.value();
                Message message = new Message();
                message.setBody(value);
                message.setKey(record.key());
                message.setMsgId(KafkaMsgIdUtils.generate(record.topic(), record.partition(), record.offset()));

                ConsumeStatus status = null;
                if (listener instanceof SingleMessageListener) {
                    status = ((SingleMessageListener) listener).consume(message, null);
                }

                if (null == status) {
                    continue;
                }

                switch (status) {
                    case CONSUME_SUCCESS:
                        this.consumer.commitAsync();
                        break;
                    default:
                }
            }
        }
    }

    @Override
    protected void doDestroy() {

    }

    @Override
    public void suspend() {
    }

    @Override
    public void shutdown() {
        if (null != this.consumer) {
            this.consumer.close();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public Listener getMessageListener() {
        return this.listener;
    }

    public int getConsumeTimeOutInMillis() {
        return consumeTimeOutInMillis;
    }

    public void setConsumeTimeOutInMillis(int consumeTimeOutInMillis) {
        this.consumeTimeOutInMillis = consumeTimeOutInMillis;
    }
}
