/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.sc.domain;

import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.sc.domain.ResourceModel;
import com.bxm.warcar.utils.PathUtils;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class StaticResourceReplaceHandler {
    private static final String DOMAIN_KEY = "STATIC_RESOURCE_DOMAIN";
    private final Pair pair;

    public StaticResourceReplaceHandler(Pair pair) {
        Preconditions.checkNotNull((Object)pair);
        this.pair = pair;
    }

    @Pointcut(value="@annotation(com.bxm.warcar.sc.domain.StaticResourceMapping)")
    public void pointcut() {
    }

    @AfterReturning(value="pointcut()", returning="returning")
    public void afterRetuning(Object returning) {
        if (null == returning) {
            return;
        }
        if (Iterable.class.isAssignableFrom(returning.getClass())) {
            this.replaceRootForIterable(returning);
        } else if (returning.getClass().isArray()) {
            this.replaceRootForArray(returning);
        } else {
            this.replaceForObject(returning);
        }
    }

    private void replaceRootForIterable(Object retuning) {
        Iterable iterable = (Iterable)retuning;
        for (Object o : iterable) {
            this.replaceForObject(o);
        }
    }

    private void replaceRootForArray(Object retuning) {
        Object[] array;
        for (Object o : array = (Object[])retuning) {
            this.replaceForObject(o);
        }
    }

    private void replaceObject(Object retuning) {
        for (Class<?> cls = retuning.getClass(); null != cls; cls = cls.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = cls.getDeclaredFields()) {
                String fieldName = declaredField.getName();
                Class<?> fieldClass = declaredField.getType();
                Object value = this.getObject(retuning, fieldName);
                if (null == value || value instanceof Number || value instanceof Boolean) continue;
                if (value instanceof String) {
                    this.replaceForString(retuning, fieldName);
                    continue;
                }
                if (value instanceof Map) {
                    this.replaceForMap(value);
                    continue;
                }
                if (value instanceof Iterable) {
                    this.replaceForIterable(value);
                    continue;
                }
                if (value instanceof Array) {
                    this.replaceForArray(value);
                    continue;
                }
                if (!Object.class.isAssignableFrom(fieldClass)) continue;
                this.replaceObject(value);
            }
        }
    }

    private void replaceForObject(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof Number) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        this.replaceObject(value);
    }

    private void replaceForArray(Object value) {
        Array[] array;
        for (Array o : array = (Array[])value) {
            this.replaceForObject(o);
        }
    }

    private void replaceForIterable(Object value) {
        Iterable iterable = (Iterable)value;
        for (Object o : iterable) {
            this.replaceForObject(o);
        }
    }

    private void replaceForMap(Object value) {
        this.disposeMap(value);
    }

    private void disposeMap(Object value) {
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            Object mv = entry.getValue();
            if (mv == null) continue;
            if (mv instanceof String) {
                String url = this.replace(mv.toString());
                Object key = entry.getKey();
                map.put(key, url);
                continue;
            }
            if (!Object.class.isAssignableFrom(mv.getClass())) continue;
            this.replaceForObject(mv);
        }
    }

    private void replaceForString(Object retuning, String fieldName) {
        Object value = this.getObject(retuning, fieldName);
        if (null == value) {
            return;
        }
        String newUrl = this.replace(value.toString());
        try {
            FieldUtils.writeField((Object)retuning, (String)fieldName, (Object)newUrl, (boolean)true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.setValue(retuning, fieldName, newUrl);
        }
    }

    private Object getObject(Object retuning, String fieldName) {
        Object value;
        try {
            value = FieldUtils.readDeclaredField((Object)retuning, (String)fieldName, (boolean)true);
        }
        catch (Exception e) {
            value = this.getValue(retuning, fieldName);
        }
        return value;
    }

    private Object getValue(Object object, String fieldName) {
        String methodName = StringUtils.join((Object[])new String[]{"get", StringUtils.capitalize((String)fieldName)});
        try {
            return MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setValue(Object object, String fieldName, Object value) {
        String methodName = StringUtils.join((Object[])new String[]{"set", StringUtils.capitalize((String)fieldName)});
        try {
            MethodUtils.invokeMethod((Object)object, (String)methodName, (Object)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String replace(String url) {
        ResourceModel resourceModel = (ResourceModel)this.pair.get(DOMAIN_KEY).toObject(ResourceModel.class);
        if (resourceModel == null) {
            return url;
        }
        if (CollectionUtils.isEmpty(resourceModel.getSourceList()) || StringUtils.isBlank((String)resourceModel.getTargetUrl())) {
            return url;
        }
        if (resourceModel.isContains(url)) {
            return PathUtils.replaceDomain((String)url, (String)resourceModel.getTargetUrl());
        }
        return url;
    }
}

