package com.bxm.warcar.utils;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * <p> http相关请求和参数工具类 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/25
 */
public final class HttpUtils {

    private HttpUtils(){}

    /**
     *  获取客户端IP
     * @date: 2018/7/25
     * @param request
     * @return java.lang.String
     * @throws 
     */
    public static String getIpFromHeader(HttpServletRequest request){
        if (null == request) {
            return null;
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotBlank(ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip.indexOf(',') == -1 ? ip : ip.substring(0, ip.indexOf(','));
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}
