/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ListOrderHelper {
    private static final int DEFULT_ZERO = 0;
    private static final int DEFULT_TWO = 2;
    private static final String ASC = "ASC";
    private static final String STRING = "string";
    private static final String SHORT = "short";
    private static final String BYTE = "byte";
    private static final String CHAR = "char";
    private static final String INTEGER = "integer";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String BOOLEAN = "boolean";
    private static final String DATE = "date";
    private static final String TIMESTAMP = "timestamp";
    private static final String COMPARETO = "compareTo";
    private static final String BIGDECIMAL = "bigdecimal";

    public static <T> void sortList(List<T> list, final String sortField, final String sortMode) {
        if (list == null || list.size() < 2) {
            return;
        }
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                try {
                    boolean ASC_order;
                    Class<?> clazz = o1.getClass();
                    Field field = clazz.getDeclaredField(sortField);
                    field.setAccessible(true);
                    String typeName = field.getType().getName().toLowerCase();
                    Object v1 = field.get(o1);
                    Object v2 = field.get(o2);
                    if (typeName.endsWith(ListOrderHelper.DOUBLE) || typeName.endsWith(ListOrderHelper.SHORT) || typeName.endsWith(ListOrderHelper.LONG) || typeName.endsWith(ListOrderHelper.INT) || typeName.endsWith(ListOrderHelper.INTEGER) || typeName.endsWith(ListOrderHelper.BIGDECIMAL)) {
                        v1 = null == v1 ? Integer.valueOf(0) : v1;
                        Object object = v2 = null == v2 ? Integer.valueOf(0) : v2;
                    }
                    if (null == v1 || null == v2) {
                        return 0;
                    }
                    boolean bl = ASC_order = sortMode == null || ListOrderHelper.ASC.equalsIgnoreCase(sortMode);
                    if (typeName.endsWith(ListOrderHelper.STRING)) {
                        String value1 = v1.toString();
                        String value2 = v2.toString();
                        if (StringUtils.isNumericSpace((CharSequence)value1.replace(".", "").replace("%", "")) && StringUtils.isNumericSpace((CharSequence)value2.replace(".", "").replace("%", ""))) {
                            Double doublevalue1 = Double.parseDouble(v1.toString().replace("%", ""));
                            Double doublevalue2 = Double.parseDouble(v2.toString().replace("%", ""));
                            return ASC_order ? doublevalue1.compareTo(doublevalue2) : doublevalue2.compareTo(doublevalue1);
                        }
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.SHORT)) {
                        Short value1 = Short.parseShort(v1.toString());
                        Short value2 = Short.parseShort(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.BYTE)) {
                        Byte value1 = Byte.parseByte(v1.toString());
                        Byte value2 = Byte.parseByte(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.CHAR)) {
                        Integer value1 = v1.toString().charAt(0);
                        Integer value2 = v2.toString().charAt(0);
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.INT) || typeName.endsWith(ListOrderHelper.INTEGER)) {
                        Integer value1 = Integer.parseInt(v1.toString());
                        Integer value2 = Integer.parseInt(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.LONG)) {
                        Long value1 = Long.parseLong(v1.toString());
                        Long value2 = Long.parseLong(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.FLOAT)) {
                        Float value1 = Float.valueOf(Float.parseFloat(v1.toString()));
                        Float value2 = Float.valueOf(Float.parseFloat(v2.toString()));
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.DOUBLE)) {
                        Double value1 = Double.parseDouble(v1.toString());
                        Double value2 = Double.parseDouble(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.BOOLEAN)) {
                        Boolean value1 = Boolean.parseBoolean(v1.toString());
                        Boolean value2 = Boolean.parseBoolean(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.DATE)) {
                        Date value1 = (Date)v1;
                        Date value2 = (Date)v2;
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.TIMESTAMP)) {
                        Timestamp value1 = (Timestamp)v1;
                        Timestamp value2 = (Timestamp)v2;
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith(ListOrderHelper.BIGDECIMAL)) {
                        BigDecimal value1 = new BigDecimal(v1.toString());
                        BigDecimal value2 = new BigDecimal(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    Method method = field.getType().getDeclaredMethod(ListOrderHelper.COMPARETO, field.getType());
                    method.setAccessible(true);
                    int result = (Integer)method.invoke(v1, v2);
                    return ASC_order ? result : result * -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }
}

