/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.crypto;

import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.utils.crypto.StringAesCipher;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;

public class Base64AesCipher {
    private static final StringAesCipher STRING_AES_CIPHER = StringAesCipher.builder().keySerializer(new Function<String, byte[]>(){

        @Override
        public byte[] apply(String s) {
            return StringHelper.convert(s);
        }
    }).contentEncryptSerializer(new Function<String, byte[]>(){

        @Override
        public byte[] apply(String s) {
            return StringHelper.convert(s);
        }
    }).contentDecryptSerializer(new Function<String, byte[]>(){

        @Override
        public byte[] apply(String s) {
            return Base64.decodeBase64((String)s);
        }
    }).contentEncryptDeserializer(new Function<byte[], String>(){

        @Override
        public String apply(byte[] bytes) {
            return Base64.encodeBase64String((byte[])bytes);
        }
    }).contentDecryptDeserializer(new Function<byte[], String>(){

        @Override
        public String apply(byte[] bytes) {
            return StringHelper.convert(bytes);
        }
    }).build();

    private Base64AesCipher() {
    }

    public static String encrypt(String key, String content) throws Exception {
        return STRING_AES_CIPHER.encrypt(key, content);
    }

    public static String decrypt(String key, String content) throws Exception {
        return STRING_AES_CIPHER.decrypt(key, content);
    }
}

