/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    private static RestTemplate restTemplate = new RestTemplate();

    public static String get(String url) {
        return (String)RestTemplateUtils.exchange(url, HttpMethod.GET).getBody();
    }

    public static String get(String url, Map<String, String> headers) {
        return RestTemplateUtils.get(url, Maps.newHashMap(), headers);
    }

    public static String get(String url, Map<String, Object> params, Map<String, String> headers) {
        return (String)RestTemplateUtils.exchange(url, headers, params, HttpMethod.GET, String.class).getBody();
    }

    public static String post(String url) {
        return (String)RestTemplateUtils.exchange(url, HttpMethod.POST).getBody();
    }

    public static String post(String url, Map<String, Object> params) {
        return RestTemplateUtils.post(url, params, Maps.newHashMap());
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> headers) {
        return (String)RestTemplateUtils.exchange(url, headers, params, HttpMethod.POST, String.class).getBody();
    }

    public static String postRequestBody(String url, Object o, Map<String, String> headers) {
        return (String)RestTemplateUtils.exchange(url, headers, o, HttpMethod.POST, String.class).getBody();
    }

    public static HttpEntity<String> exchange(String url, HttpMethod method) {
        return RestTemplateUtils.exchange(url, method, Maps.newHashMap());
    }

    public static <T> HttpEntity<T> get(String url, Class<T> responseType) {
        return RestTemplateUtils.exchange(url, HttpMethod.GET, responseType);
    }

    public static <T> HttpEntity<T> post(String url, Class<T> responseType) {
        return RestTemplateUtils.exchange(url, HttpMethod.POST, responseType);
    }

    public static <T> HttpEntity<T> exchange(String url, HttpMethod method, Class<T> responseType) {
        return RestTemplateUtils.exchange(url, Maps.newHashMap(), method, responseType);
    }

    public static HttpEntity<String> exchange(String url, HttpMethod method, Map<String, Object> bodyParams) {
        return RestTemplateUtils.exchange(url, bodyParams, method, String.class);
    }

    public static <T> HttpEntity<T> exchange(String url, Map<String, Object> bodyParams, HttpMethod method, Class<T> responseType) {
        return RestTemplateUtils.exchange(url, Maps.newHashMap(), bodyParams, method, responseType);
    }

    public static <T> HttpEntity<T> exchange(String url, Map<String, String> headers, Object bodyParams, HttpMethod method, Class<T> responseType) {
        return RestTemplateUtils.exchange(url, headers, bodyParams, method, responseType, null);
    }

    public static <T> HttpEntity<T> exchange(String url, Map<String, String> headers, Object bodyParams, HttpMethod method, Class<T> responseType, String contentType) {
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        }
        HttpEntity httpEntity = new HttpEntity(bodyParams, RestTemplateUtils.headerParams(headers));
        if (bodyParams instanceof Map) {
            LinkedMultiValueMap<String, String> multiValueMap = RestTemplateUtils.praseBodyParams((Map)bodyParams);
            httpEntity = new HttpEntity(multiValueMap, RestTemplateUtils.headerParams(headers));
            return restTemplate.exchange(url, method, httpEntity, responseType, new Object[0]);
        }
        return restTemplate.exchange(url, method, httpEntity, responseType, new Object[0]);
    }

    public static LinkedMultiValueMap<String, String> headerParams(Map<String, String> headers) {
        LinkedMultiValueMap headerParams = new LinkedMultiValueMap();
        headers.forEach((arg_0, arg_1) -> ((LinkedMultiValueMap)headerParams).add(arg_0, arg_1));
        return headerParams;
    }

    public static LinkedMultiValueMap<String, String> praseBodyParams(Map<String, Object> bodyParams) {
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        if (MapUtils.isNotEmpty(bodyParams)) {
            for (Map.Entry<String, Object> entry : bodyParams.entrySet()) {
                Object value = entry.getValue();
                if (null == value) continue;
                linkedMultiValueMap.put((Object)entry.getKey(), (List)Lists.newArrayList((Object[])new String[]{value.toString()}));
            }
        }
        return linkedMultiValueMap;
    }
}

