/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.file;

import com.bxm.warcar.utils.file.DataTracker;
import com.bxm.warcar.utils.file.FingerprintTracker;
import com.bxm.warcar.utils.file.LicenseTracker;
import com.bxm.warcar.utils.file.SystemFileComparator;
import java.io.File;

public final class SystemFileComparatorFactory {
    private File fingerprint;
    private File data;
    private File license;
    private FingerprintTracker fingerprintTracker;
    private DataTracker dataTracker;
    private LicenseTracker licenseTracker;

    private SystemFileComparatorFactory() {
    }

    public static SystemFileComparatorFactory create() {
        return new SystemFileComparatorFactory();
    }

    public SystemFileComparatorFactory fingerprint(File fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    public SystemFileComparatorFactory data(File data) {
        this.data = data;
        return this;
    }

    public SystemFileComparatorFactory license(File license) {
        this.license = license;
        return this;
    }

    public SystemFileComparatorFactory fingerprintTracker(FingerprintTracker fingerprintTracker) {
        this.fingerprintTracker = fingerprintTracker;
        return this;
    }

    public SystemFileComparatorFactory dataTracker(DataTracker dataTracker) {
        this.dataTracker = dataTracker;
        return this;
    }

    public SystemFileComparatorFactory licenseTracker(LicenseTracker licenseTracker) {
        this.licenseTracker = licenseTracker;
        return this;
    }

    public SystemFileComparator build() {
        return new SystemFileComparator(this.fingerprint, this.data, this.license, this.fingerprintTracker, this.dataTracker, this.licenseTracker);
    }
}

