/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.file;

import com.bxm.warcar.utils.file.ByteTracker;
import com.bxm.warcar.utils.file.SimpleDataTracker;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleByteTracker
implements ByteTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDataTracker.class);
    private final String url;
    private final String cacheFileName;

    public SimpleByteTracker(String url, String cacheFileName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)url));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)cacheFileName));
        this.url = url;
        this.cacheFileName = cacheFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getContent() {
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream os = null;
        try {
            int len;
            urlConnection = (HttpURLConnection)new URL(this.url).openConnection();
            inputStream = urlConnection.getInputStream();
            int available = inputStream.available();
            long start = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Starting download, The content length is {}...", (Object)this.url, (Object)available);
            }
            os = new ByteArrayOutputStream(available);
            byte[] buffer = new byte[0xA00000];
            while ((len = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.flush();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Finished in {} ms!", (Object)this.url, (Object)(System.currentTimeMillis() - start));
            }
            byte[] byArray = os.toByteArray();
            IOUtils.closeQuietly((InputStream)inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
            return byArray;
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getLicense: ", (Throwable)e);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public String getCacheFileName() {
        return this.cacheFileName;
    }
}

