/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;


import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;

import java.lang.reflect.Field;


public class NotNullValidator extends AbstractValidator {

	public NotNullValidator(Field field) {
		super(field);
	}

	@Override
	protected void doValidate(Object input) throws Exception {
		Object v = getValue(input);
		if (null == v)
			throw new ConstraintViolationException(this);
	}

	@Override
	public String getConstraintDesc() {
		return getFieldDesc() + " must not be allow null.";
	}
}
