/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import org.apache.commons.lang.math.NumberUtils;

import java.lang.reflect.Field;


public class NumericValidator extends AbstractValidator {

	private final static long DEFAULT_MIN = Long.MIN_VALUE;
	private final static long DEFAULT_MAX = Long.MAX_VALUE;

	private final long min;
	private final long max;

	public NumericValidator(Field field) {
		this(field, DEFAULT_MIN, DEFAULT_MAX);
	}

	public NumericValidator(Field field, long min, long max) {
		super(field);
		if (min > max)
			throw new IllegalArgumentException("min:" + min + " max:" + max);
		this.min = min;
		this.max = max;
	}

	@Override
	protected void doValidate(Object input) throws Exception {
		String v = String.valueOf(getValue(input));
		if (!NumberUtils.isNumber(v))
			throw new ConstraintViolationException(this, v);
		long lv = NumberUtils.toLong(v);
		if (lv < min || lv > max)
			throw new ConstraintViolationException(this, v);
	}

	@Override
	public String getConstraintDesc() {
		return getFieldDesc() + " must be numeric,value range:[" + min + "," + max + "]";
	}
}
