/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate;

import com.bxm.warcar.validate.ValidateException;
import com.bxm.warcar.validate.Validator;
import org.apache.commons.lang.StringUtils;

public class ConstraintViolationException
extends ValidateException {
    private static final long serialVersionUID = 7012026401290474475L;
    private final String constraintDesc;

    public ConstraintViolationException(Validator validator, String message, Throwable cause) {
        super(message, cause);
        if (null == validator) {
            throw new NullPointerException("validator");
        }
        if (StringUtils.isBlank((String)validator.getConstraintDesc())) {
            throw new IllegalArgumentException("constraintDesc is blank.");
        }
        this.constraintDesc = validator.getConstraintDesc();
    }

    public ConstraintViolationException(Validator validator) {
        this(validator, "");
    }

    public ConstraintViolationException(Validator validator, String message) {
        super(message);
        if (null == validator) {
            throw new NullPointerException("validator");
        }
        if (StringUtils.isBlank((String)validator.getConstraintDesc())) {
            throw new IllegalArgumentException("constraintDesc is blank.");
        }
        this.constraintDesc = validator.getConstraintDesc();
    }

    public String getConstraintDesc() {
        return this.constraintDesc;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(64).append("Violate Constraint:").append(this.constraintDesc);
        if (StringUtils.isNotBlank((String)super.getMessage())) {
            sb.append(", details:").append(super.getMessage());
        }
        return sb.toString();
    }
}

