/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate.factory;

import com.bxm.warcar.utils.ReflectUtils;
import com.bxm.warcar.validate.Validator;
import com.bxm.warcar.validate.annotation.ValidateCollection;
import com.bxm.warcar.validate.annotation.ValidateCustom;
import com.bxm.warcar.validate.annotation.ValidateLength;
import com.bxm.warcar.validate.annotation.ValidateNotGreatThan;
import com.bxm.warcar.validate.annotation.ValidateNotLaterThan;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import com.bxm.warcar.validate.annotation.ValidateNumeric;
import com.bxm.warcar.validate.annotation.ValidatePattern;
import com.bxm.warcar.validate.factory.ValidateAnnotationMisuseException;
import com.bxm.warcar.validate.factory.ValidatorCreateException;
import com.bxm.warcar.validate.factory.ValidatorFactory;
import com.bxm.warcar.validate.factory.ValidatorMetadata;
import com.bxm.warcar.validate.internal.BeanValidator;
import com.bxm.warcar.validate.internal.BeanValidatorWrapper;
import com.bxm.warcar.validate.internal.CollectionValidator;
import com.bxm.warcar.validate.internal.CustomValidator;
import com.bxm.warcar.validate.internal.LengthValidator;
import com.bxm.warcar.validate.internal.NotGreatThanValidator;
import com.bxm.warcar.validate.internal.NotLaterThanValidator;
import com.bxm.warcar.validate.internal.NotNullValidator;
import com.bxm.warcar.validate.internal.NumericValidator;
import com.bxm.warcar.validate.internal.PatternValidator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AnnotationValidatorFactory
implements ValidatorFactory {
    private final Map<Class<? extends Annotation>, ValidatorMetadata> validatorMetadatas = Maps.newHashMap();

    public AnnotationValidatorFactory() {
        this.initValidatorMetadatas();
    }

    private void initValidatorMetadatas() {
        this.registerValidatorMetadata(new ValidatorMetadata(ValidateCollection.class){

            @Override
            public Validator create(Field f, Annotation anno) {
                ValidateCollection an = (ValidateCollection)anno;
                Class<? extends Validator> clazz = an.elementValidator();
                try {
                    return new CollectionValidator(f, clazz.newInstance(), an.allowEmpty(), an.minSize(), an.maxSize());
                }
                catch (InstantiationException e) {
                    throw new ValidatorCreateException("CollectionValidator create:", e);
                }
                catch (IllegalAccessException e) {
                    throw new ValidatorCreateException("CollectionValidator create:", e);
                }
            }

            @Override
            public void match(Class<?> clazz) {
                if (!List.class.isAssignableFrom(clazz) && !clazz.isArray()) {
                    throw new ValidateAnnotationMisuseException(this.getAnnoClass(), " expect List or Array,but " + clazz);
                }
            }
        });
        this.registerValidatorMetadata(new ValidatorMetadata(ValidateLength.class){

            @Override
            public Validator create(Field f, Annotation anno) {
                ValidateLength an = (ValidateLength)anno;
                return new LengthValidator(f, an.min(), an.max());
            }

            @Override
            public void match(Class<?> clazz) {
                if (String.class != clazz) {
                    throw new ValidateAnnotationMisuseException(this.getAnnoClass(), " expect String,but " + clazz);
                }
            }
        });
        this.registerValidatorMetadata(new ValidatorMetadata(ValidateNotGreatThan.class){

            @Override
            public Validator create(Field f, Annotation anno) {
                Field cf;
                ValidateNotGreatThan an = (ValidateNotGreatThan)anno;
                String cfn = an.compareField();
                try {
                    cf = f.getDeclaringClass().getDeclaredField(cfn);
                }
                catch (SecurityException e) {
                    throw new ValidatorCreateException("NotGreatThanValidator create:", e);
                }
                catch (NoSuchFieldException e) {
                    throw new ValidatorCreateException("NotGreatThanValidator create:", e);
                }
                return new NotGreatThanValidator(f, cf);
            }

            @Override
            public void match(Class<?> clazz) {
                if (Byte.class != clazz && Byte.TYPE != clazz && Short.class != clazz && Short.TYPE != clazz && Integer.class != clazz && Integer.TYPE != clazz && Long.class != clazz && Long.TYPE != clazz) {
                    throw new ValidateAnnotationMisuseException(this.getAnnoClass(), " expect Numeric,but " + clazz);
                }
            }
        });
        this.registerValidatorMetadata(new ValidatorMetadata(ValidateNotLaterThan.class){

            @Override
            public Validator create(Field f, Annotation anno) {
                Field cf;
                ValidateNotLaterThan an = (ValidateNotLaterThan)anno;
                String cfn = an.compareField();
                try {
                    cf = f.getDeclaringClass().getField(cfn);
                }
                catch (SecurityException e) {
                    throw new ValidatorCreateException("NotLaterThanValidator create:", e);
                }
                catch (NoSuchFieldException e) {
                    throw new ValidatorCreateException("NotLaterThanValidator create:", e);
                }
                return new NotLaterThanValidator(f, cf);
            }

            @Override
            public void match(Class<?> clazz) {
                if (!Date.class.isAssignableFrom(clazz)) {
                    throw new ValidateAnnotationMisuseException(this.getAnnoClass(), " expect Date,but " + clazz);
                }
            }
        });
        this.registerValidatorMetadata(new ValidatorMetadata(ValidateNotNull.class){

            @Override
            public Validator create(Field f, Annotation anno) {
                return new NotNullValidator(f);
            }

            @Override
            public void match(Class<?> clazz) {
                if (clazz.isPrimitive()) {
                    throw new ValidateAnnotationMisuseException(this.getAnnoClass(), " expect Object,but " + clazz);
                }
            }
        });
        this.registerValidatorMetadata(new ValidatorMetadata(ValidateNumeric.class){

            @Override
            public Validator create(Field f, Annotation anno) {
                ValidateNumeric an = (ValidateNumeric)anno;
                return new NumericValidator(f, an.min(), an.max());
            }

            @Override
            public void match(Class<?> clazz) {
                if (Byte.class != clazz && Byte.TYPE != clazz && Short.class != clazz && Short.TYPE != clazz && Integer.class != clazz && Integer.TYPE != clazz && Long.class != clazz && Long.TYPE != clazz && String.class != clazz) {
                    throw new ValidateAnnotationMisuseException(this.getAnnoClass(), " expect Numeric,but " + clazz);
                }
            }
        });
        this.registerValidatorMetadata(new ValidatorMetadata(ValidatePattern.class){

            @Override
            public Validator create(Field f, Annotation anno) {
                ValidatePattern an = (ValidatePattern)anno;
                return new PatternValidator(f, an.value());
            }

            @Override
            public void match(Class<?> clazz) {
                if (String.class != clazz) {
                    throw new ValidateAnnotationMisuseException(this.getAnnoClass(), " expect String,but " + clazz);
                }
            }
        });
        this.registerValidatorMetadata(new ValidatorMetadata(ValidateCustom.class){

            @Override
            public Validator create(Field f, Annotation anno) {
                ValidateCustom an = (ValidateCustom)anno;
                Class<? extends Validator> clazz = an.validator();
                try {
                    return new CustomValidator(f, clazz.newInstance());
                }
                catch (InstantiationException e) {
                    throw new ValidatorCreateException("CustomValidator create:", e);
                }
                catch (IllegalAccessException e) {
                    throw new ValidatorCreateException("CustomValidator create:", e);
                }
            }

            @Override
            public void match(Class<?> clazz) {
            }
        });
    }

    @Override
    public Validator create(Class<?> beanClass) {
        List<Validator> childValidators = this.createValidator(beanClass);
        if (childValidators.isEmpty()) {
            return null;
        }
        BeanValidator beanValidator = new BeanValidator();
        beanValidator.register(childValidators);
        return beanValidator;
    }

    private List<Validator> create(Field f) {
        Annotation[] annos;
        ArrayList ret = Lists.newArrayList();
        Class<?> clazz = f.getType();
        for (Annotation anno : annos = f.getAnnotations()) {
            ValidatorMetadata vm = this.validatorMetadatas.get(anno.annotationType());
            if (null == vm) continue;
            vm.match(clazz);
            Validator validator = vm.create(f, anno);
            ret.add(validator);
        }
        final ArrayList childValidators = Lists.newArrayList();
        if (clazz.isPrimitive() || String.class == clazz) {
            return ret;
        }
        ReflectUtils.findFields(clazz, (ReflectUtils.FieldFilter)new ReflectUtils.FieldFilter(){

            public boolean accept(Field _f) {
                List vs = AnnotationValidatorFactory.this.create(_f);
                childValidators.addAll(vs);
                return false;
            }
        });
        if (childValidators.size() > 0) {
            BeanValidator beanValidator = new BeanValidator();
            for (Validator childValidator : childValidators) {
                beanValidator.register(childValidator);
            }
            ret.add(new BeanValidatorWrapper(f, beanValidator));
        }
        return ret;
    }

    private List<Validator> createValidator(Class<?> beanClass) {
        ArrayList ret = Lists.newArrayList();
        do {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = beanClass.getDeclaredFields()) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = declaredField.getAnnotations()) {
                    ValidatorMetadata validatorMetadata = this.validatorMetadatas.get(annotation.annotationType());
                    if (null == validatorMetadata) continue;
                    validatorMetadata.match(declaredField.getType());
                    Validator validator = validatorMetadata.create(declaredField, annotation);
                    ret.add(validator);
                }
            }
        } while (null != (beanClass = beanClass.getSuperclass()));
        return ret;
    }

    public void registerValidatorMetadata(ValidatorMetadata metadata) {
        this.validatorMetadatas.put(metadata.getAnnoClass(), metadata);
    }
}

