/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;


import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;

/**
 * imei or idfa Validator
 *
 * @ClassName ImeiOrIdfalValidator
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/20 18:15
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/20 18:15
 **/
public class ImeiOrIdfalValidator extends AbstractValidator {
	/**
	 * 最短长度
	 */
	private final int IMEI_MIN_LENGTH = 12;

	/**
	 * 最长长度
	 */
	private final int IMEI_MAX_LENGTH = 32;

	public ImeiOrIdfalValidator(Field field) {
		super(field);
	}

	public ImeiOrIdfalValidator(Field field, String value) {
		super(field, value);
	}

	/**
	 * imei or idfa 校验器
	 * 规则：
	 * 1.为空或者小于12位 则置空
	 * 2.非空长度大于12 且小于32位则进行MD5加密
	 *
	 * @param input
	 * @return void
	 * @throws
	 * @author kk.xie
	 * @date 2018/7/26 12:01
	 */
	@Override
	protected void doValidate(Object input) throws Exception {
		String defaultValue = getDefaultValue();
		defaultValue = defaultValue == null ? "" : defaultValue;

		Object v = getValue(input);
		String stringValue = v == null ? "" : v.toString();
		// IMEI 或 IDFA 为NULL 或者 大于32位 或 小于等于12位则置空，有默认值则使用默认值
		if(stringValue.length() <= IMEI_MIN_LENGTH || stringValue.length() > IMEI_MAX_LENGTH){
			setValue(input, defaultValue);
		}
		// IMEI 或 IDFA 长度大于12位 小于32位 则进行MD5加密
		if(IMEI_MIN_LENGTH < stringValue.length() && stringValue.length() < IMEI_MAX_LENGTH){
			setValue(input, DigestUtils.md5Hex(stringValue.getBytes("UTF-8")));
		}
	}

	@Override
	public String getConstraintDesc() {
		return getFieldDesc() + " must not be allow null.";
	}
}
