/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate.factory;

import com.bxm.warcar.validate.Validator;
import com.bxm.warcar.validate.factory.ValidatorFactory;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class PreGeneratedValidatorFactory
implements ValidatorFactory {
    private final Map<Class<?>, Validator> validators;

    public PreGeneratedValidatorFactory(ValidatorFactory validatorFactory, List<Class<?>> modelClasses) {
        if (null == validatorFactory) {
            throw new NullPointerException("validatorFactory");
        }
        if (null == modelClasses || modelClasses.isEmpty()) {
            throw new IllegalArgumentException("Validate modelClasses is blank.");
        }
        this.validators = Maps.newHashMap();
        for (Class<?> modelClass : modelClasses) {
            Validator validator = validatorFactory.create(modelClass);
            this.validators.put(modelClass, validator);
        }
    }

    @Override
    public Validator create(Class<?> beanClass) {
        if (null == beanClass) {
            throw new NullPointerException("beanClass");
        }
        return this.validators.get(beanClass);
    }
}

