/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.demo;

import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.web.util.Encrypted;
import com.bxm.warcar.web.util.EncryptedMessage;
import com.bxm.warcar.web.util.TextFormat;
import com.bxm.warcar.web.util.serialization.PrimitiveSerialization;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestController
public class WelcomeController {
    private static final Logger log = LoggerFactory.getLogger(WelcomeController.class);

    @GetMapping(value={"/"})
    public ResponseEntity<Object> welcome(HttpServletRequest request) {
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request);
        return ResponseEntity.ok((Object)("Hello: " + request.getHeader("X-Forwarded-For")));
    }

    @PostMapping(value={"/post"})
    public ResponseEntity<Object> post(@RequestBody String json) {
        log.info("json: {}", (Object)json);
        return ResponseEntity.ok((Object)json);
    }

    @Encrypted(model=CipherRequest.class, encryptResponseEntity=true)
    @PostMapping(value={"/cipher"})
    public ResponseEntity<CipherResponse> cipher(@RequestBody EncryptedMessage<CipherRequest> message) {
        log.info(JsonHelper.convert(message));
        CipherRequest request = (CipherRequest)message.getObject();
        CipherResponse response = new CipherResponse();
        response.setMessage("Hello " + request.getName() + ", How are you today?");
        return ResponseEntity.ok((Object)response);
    }

    @Encrypted(model=Integer.class, serialization=PrimitiveSerialization.class)
    @PostMapping(value={"/cipher_integer"})
    public ResponseEntity<Integer> cipherInteger(@RequestBody EncryptedMessage<Integer> message) {
        Integer integer = (Integer)message.getObject();
        log.info(integer.toString());
        return ResponseEntity.ok((Object)integer);
    }

    @Encrypted(model=CipherRequest.class, encryptResponseEntity=true, plaintextFormat=TextFormat.PARAMS)
    @GetMapping(value={"/cipher"})
    public ResponseEntity<CipherResponse> cipherGet(EncryptedMessage<CipherRequest> message) {
        log.info(JsonHelper.convert(message));
        CipherRequest request = (CipherRequest)message.getObject();
        CipherResponse response = new CipherResponse();
        response.setMessage("Hello " + request.getName() + ", How are you today?");
        return ResponseEntity.ok((Object)response);
    }

    @Encrypted(model=Integer.class, serialization=PrimitiveSerialization.class)
    @GetMapping(value={"/cipher_integer"})
    public ResponseEntity<Integer> cipherIntegerGet(EncryptedMessage<Integer> message) {
        Integer integer = (Integer)message.getObject();
        log.info(integer.toString());
        return ResponseEntity.ok((Object)integer);
    }

    static class CipherResponse {
        private String message;

        CipherResponse() {
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    static class CipherRequest {
        private String name;
        private int age;

        CipherRequest() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

