/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.util;

import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.web.util.EncryptContext;
import com.bxm.warcar.web.util.Encrypted;
import com.bxm.warcar.web.util.EncryptedMessage;
import com.bxm.warcar.web.util.Encryptor;
import com.bxm.warcar.web.util.EncryptorFactory;
import com.bxm.warcar.web.util.Serialization;
import com.bxm.warcar.web.util.TextFormat;
import com.bxm.warcar.web.util.WebContextUtils;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

@Aspect
public class EncryptedControllerMethodAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedControllerMethodAspect.class);
    private final Set<Class<?>> primitives = Sets.newHashSet((Object[])new Class[]{String.class, Short.class, Byte.class, Integer.class, Float.class, Long.class, Boolean.class, Double.class, BigDecimal.class});
    private final EncryptorFactory encryptorFactory;

    public EncryptedControllerMethodAspect(EncryptorFactory encryptorFactory) {
        this.encryptorFactory = encryptorFactory;
    }

    @Pointcut(value="@annotation(com.bxm.warcar.web.util.Encrypted)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        String body;
        String key;
        Encryptor encryptor;
        EncryptedMessage message;
        Encrypted encrypted;
        block19: {
            Object[] args = point.getArgs();
            if (args.length == 0) {
                return point.proceed();
            }
            HttpServletRequest request = WebContextUtils.getRequest();
            HttpServletResponse response = WebContextUtils.getResponse();
            if (Objects.isNull(request) || Objects.isNull(response)) {
                return point.proceed();
            }
            Method method = this.getMethod(point);
            try {
                encrypted = Objects.requireNonNull(method).getAnnotation(Encrypted.class);
            }
            catch (NullPointerException e) {
                return point.proceed();
            }
            Object arg = null;
            for (Object o : args) {
                if (!(o instanceof EncryptedMessage)) continue;
                arg = o;
                break;
            }
            if (Objects.isNull(arg)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Method [{}] Cannot found EncryptedMessage object in arguments list.", (Object)method);
                }
                return point.proceed();
            }
            message = (EncryptedMessage)arg;
            String msg = message.getMessage();
            if (StringUtils.isBlank((String)msg)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Method [{}] message is blank", (Object)method);
                }
                return point.proceed();
            }
            Integer cipherVersion = message.getCipher();
            if (null == cipherVersion) {
                return point.proceed();
            }
            encryptor = this.encryptorFactory.get(cipherVersion);
            if (Objects.isNull(encryptor)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Method [{}]  unsupported cipher version: {}", (Object)method, (Object)cipherVersion);
                }
                return point.proceed();
            }
            key = encryptor.getKey(request);
            body = null;
            try {
                body = encryptor.decrypt(new EncryptContext().setContent(msg).setKey(key));
            }
            catch (Exception e) {
                if (!encrypted.interruptForException()) break block19;
                response.setStatus(HttpStatus.BAD_REQUEST.value());
                return null;
            }
        }
        Class<?> model = encrypted.model();
        TextFormat textFormat = encrypted.plaintextFormat();
        Object object = this.serializeBody(textFormat, body, model);
        MethodUtils.invokeMethod((Object)message, (String)"setObject", (Object[])new Object[]{object});
        Object proceed = point.proceed();
        if (Objects.isNull(proceed)) {
            return null;
        }
        if (encrypted.encryptResponseEntity()) {
            if (proceed instanceof ResponseEntity) {
                ResponseEntity entity = (ResponseEntity)proceed;
                HttpStatus[] httpStatuses = encrypted.encryptResponseHttpStatus();
                boolean flag = false;
                for (HttpStatus httpStatus : httpStatuses) {
                    if (httpStatus != entity.getStatusCode()) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)entity.getStatusCode()).headers(entity.getHeaders())).body(this.processResponse(encrypted, encryptor, key, proceed));
                }
                return proceed;
            }
            return this.processResponse(encrypted, encryptor, key, proceed);
        }
        return proceed;
    }

    private Object serializeBody(TextFormat textFormat, String body, Class<?> model) {
        if (StringUtils.isNotBlank((String)body)) {
            if (TextFormat.PARAMS == textFormat) {
                return this.convertModel(body, model);
            }
            return JsonHelper.convert((String)body, model);
        }
        return null;
    }

    private Serialization newInstance(Class<? extends Serialization> clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    private Object processResponse(Encrypted encrypted, Encryptor encryptor, String key, Object proceed) throws InstantiationException, IllegalAccessException {
        Object res = proceed instanceof ResponseEntity ? ((ResponseEntity)proceed).getBody() : proceed;
        if (Objects.isNull(res)) {
            return null;
        }
        Class<? extends Serialization> serializationClass = encrypted.serialization();
        Serialization instance = this.newInstance(serializationClass);
        return encryptor.encrypt(new EncryptContext().setContent(instance.serialize(res)).setKey(key));
    }

    private Method getMethod(ProceedingJoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getMethod:", (Throwable)e);
            }
            return null;
        }
    }

    @Deprecated
    private boolean isPrimitive(Class<?> clazz) {
        return this.primitives.stream().anyMatch(clazz::isAssignableFrom);
    }

    public Object convertModel(String body, Class<?> model) {
        String[] params;
        HashMap<String, String> properties = new HashMap<String, String>();
        block0: for (String param : params = body.split("&")) {
            String[] kv = param.split("=");
            if (kv.length != 2) continue;
            if (kv[0].indexOf(".") > -1) {
                String[] keyArr = kv[0].split("\\.");
                HashMap parent = properties;
                for (int i = 0; i < keyArr.length; ++i) {
                    String key = keyArr[i];
                    if (i == keyArr.length - 1) {
                        parent.put(key, kv[1]);
                        continue block0;
                    }
                    HashMap m = (HashMap)parent.get(key);
                    if (null == m) {
                        m = new HashMap();
                        parent.put(key, m);
                    }
                    parent = m;
                }
                continue;
            }
            properties.put(kv[0], kv[1]);
        }
        return JsonHelper.convert((String)JsonHelper.convert(properties), model);
    }
}

