package com.bxm.warcar.web.util;

import javax.servlet.http.HttpServletRequest;

/**
 * 加解密处理器
 *
 * @author allen
 * @date 2020-10-10
 * @since 1.0
 */
public interface Encryptor {

    /**
     * 返回这个加解密器的版本
     * @return 版本号
     */
    int getVersion();

    /**
     * 返回密钥从请求中获取
     * @param request HttpServletRequest
     * @return 密钥
     */
    String getKey(HttpServletRequest request);

    /**
     * 对内容进行加密
     * @param context 上下文
     * @return 密文
     */
    String encrypt(EncryptContext context);

    /**
     * 对内容进行解密
     * @param context 上下文
     * @return 明文
     * @throws Exception 不能正常解密
     */
    String decrypt(EncryptContext context) throws Exception;
}
