/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.zk.listener.children;

import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.Changed;
import com.bxm.warcar.zk.listener.ChildrenChangedListener;
import com.bxm.warcar.zk.listener.NodeChangedListener;
import java.io.IOException;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenChanged
extends LifeCycle
implements Changed {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChildrenChanged.class);
    private final ZkClientHolder zkClientHolder;
    private final String path;
    private final ChildrenChangedListener listener;
    private PathChildrenCache cache;

    public ChildrenChanged(ZkClientHolder zkClientHolder, String path, ChildrenChangedListener listener) {
        this.zkClientHolder = zkClientHolder;
        this.path = path;
        this.listener = listener;
    }

    @Override
    public void addListener(NodeChangedListener listener) {
        if (null == listener) {
            return;
        }
        if (null != this.cache) {
            this.cache.getListenable().addListener((curatorFramework, event) -> {
                ChildData childData = event.getData();
                if (null == childData) {
                    return;
                }
                String path = childData.getPath();
                byte[] data = childData.getData();
                PathChildrenCacheEvent.Type type = event.getType();
                if (listener instanceof ChildrenChangedListener) {
                    ChildrenChangedListener childrenChangedListener = (ChildrenChangedListener)listener;
                    if (type == PathChildrenCacheEvent.Type.CHILD_ADDED) {
                        childrenChangedListener.add(path, data);
                    } else if (type == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                        childrenChangedListener.update(path, data);
                    } else if (type == PathChildrenCacheEvent.Type.CHILD_REMOVED) {
                        childrenChangedListener.remove(path, data);
                    }
                } else if (type == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                    listener.update(path, data);
                }
            });
        }
    }

    protected void doInit() {
        this.cache = new PathChildrenCache(this.zkClientHolder.get(), this.path, true);
        try {
            this.cache.start();
        }
        catch (Exception e) {
            throw new RuntimeException("start: ", e);
        }
        this.addListener(this.listener);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ZooKeeper path: {} was listening children!", (Object)this.path);
        }
    }

    protected void doDestroy() {
        block3: {
            if (null != this.cache) {
                try {
                    this.cache.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error("close:", (Throwable)e);
                }
            }
        }
    }
}

