package com.bxm.warcar.zk.listener;

import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.util.concurrent.MoreExecutors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @since 1.0.0
 */
public interface NodeChangedListener {

    void update(String path, byte[] data);

    /**
     * @return 是否延迟关闭，即表示线程池内的任务队列全部执行完才会结束。
     */
    default boolean isDelayedShutdown() {
        return false;
    }

    /**
     * 返回监听器的处理线程池实现。
     * @return 线程池实现
     */
    default ExecutorService getExecutorService() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(10, 10, 10, TimeUnit.SECONDS, new LinkedBlockingQueue<>(), new NamedThreadFactory("listener"));
        return isDelayedShutdown() ? MoreExecutors.getExitingExecutorService(threadPoolExecutor) : threadPoolExecutor;
    }
}
