/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.configure.loader.zk;

import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <h3>ZooKeeper holder</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/21
 */
public final class ZooKeeperHolder extends LifeCycle {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperEnvironmentLoader.class);

    public static final int MAX_RETRIES = 3;
    public static final int BASE_SLEEP_TIMEMS = 3000;
    public static final int SESSION_TIMEOUT = 60000;

    private CuratorFramework zkClient;

    private final String connectString;
    private final int sessionTimeout;
    private final String namespace;

    public ZooKeeperHolder(String connectString) {
        this(connectString, SESSION_TIMEOUT);
    }

    public ZooKeeperHolder(String connectString, int sessionTimeout) {
        this(connectString, sessionTimeout, null);
    }

    public ZooKeeperHolder(String connectString, int sessionTimeout, String namespace) {
        Preconditions.checkArgument(StringUtils.isNotBlank(connectString), "connectString cannot be blank");
        Preconditions.checkArgument(sessionTimeout >= 10000, "sessionTimeout must be greater than 10000");
        this.connectString = connectString;
        this.sessionTimeout = sessionTimeout;
        this.namespace = namespace;
    }

    @Override
    public void doInit() {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder()
                .sessionTimeoutMs(sessionTimeout)
                .connectString(connectString)
                .retryPolicy(new ExponentialBackoffRetry(BASE_SLEEP_TIMEMS, MAX_RETRIES));
        if (StringUtils.isNotBlank(namespace)) {
            builder.namespace(namespace);
        }
        zkClient = builder.build();
        zkClient.start();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connected to ZooKepper server: {}", connectString);
        }
    }

    @Override
    public void doDestroy() {
        if (null != zkClient) {
            zkClient.close();
        }
    }

    public CuratorFramework getClient() {
        return this.zkClient;
    }
}
