package com.bxm.warcar.integration.interceptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 抽象的拦截器，实现了拦截器的链接（即可设置下一个拦截器）
 *
 * @author allen
 * @date 2017-11-28
 */
public abstract class AbstractInterceptor implements Interceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInterceptor.class);

    private Interceptor nextInterceptor;

    public AbstractInterceptor() {
        this(END);
    }

    public AbstractInterceptor(Interceptor next) {
        this.nextInterceptor = next;
    }

    /**
     * 业务处理
     * @param invocation
     */
    protected abstract void doIntercept(Invocation invocation);

    @Override
    public void intercept(Invocation invocation) {
        try {
            doIntercept(invocation);
        } catch (Exception e) {
            // Ignore exception.
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("intercept: ", e);
            }
        }

        invocation.setPreInterceptor(this);

        if (null == nextInterceptor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("next interceptor is null, ignore.");
            }
            return;
        }
        nextInterceptor.intercept(invocation);
    }

    public void setNextInterceptor(Interceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }
}
