/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector;

import com.ckfinder.connector.ServletContextFactory;
import com.ckfinder.connector.configuration.Configuration;
import com.ckfinder.connector.configuration.ConfigurationFactory;
import com.ckfinder.connector.configuration.Events;
import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.BeforeExecuteCommandEventArgs;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.Command;
import com.ckfinder.connector.handlers.command.CopyFilesCommand;
import com.ckfinder.connector.handlers.command.CreateFolderCommand;
import com.ckfinder.connector.handlers.command.DeleteFilesCommand;
import com.ckfinder.connector.handlers.command.DeleteFolderCommand;
import com.ckfinder.connector.handlers.command.DownloadFileCommand;
import com.ckfinder.connector.handlers.command.ErrorCommand;
import com.ckfinder.connector.handlers.command.FileUploadCommand;
import com.ckfinder.connector.handlers.command.GetFilesCommand;
import com.ckfinder.connector.handlers.command.GetFoldersCommand;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.InitCommand;
import com.ckfinder.connector.handlers.command.LoadCookiesCommand;
import com.ckfinder.connector.handlers.command.MoveFilesCommand;
import com.ckfinder.connector.handlers.command.QuickUploadCommand;
import com.ckfinder.connector.handlers.command.RenameFileCommand;
import com.ckfinder.connector.handlers.command.RenameFolderCommand;
import com.ckfinder.connector.handlers.command.ThumbnailCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.handlers.command.XMLErrorCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConnectorServlet
extends HttpServlet {
    private Exception startException;
    private static final long serialVersionUID = 2960665641425153638L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        this.getResponse(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        this.getResponse(request, response, true);
    }

    private void getResponse(HttpServletRequest request, HttpServletResponse response, boolean post) throws ServletException {
        if (this.startException != null && Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
            throw new ServletException((Throwable)this.startException);
        }
        String command = request.getParameter("command");
        IConfiguration configuration = null;
        try {
            configuration = ConfigurationFactory.getInstace().getConfiguration(request);
            if (configuration == null) {
                throw new Exception("Configuration wasn't initialized correctly. Check server logs.");
            }
        }
        catch (Exception e) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
                e.printStackTrace();
            }
            throw new ServletException((Throwable)e);
        }
        try {
            if (command == null || command.equals("")) {
                throw new ConnectorException(10, false);
            }
            configuration.setDebugMode(Boolean.valueOf(this.getServletConfig().getInitParameter("debug")));
            CommandHandlerEnum cmd = null;
            try {
                cmd = CommandHandlerEnum.valueOf(command.toUpperCase());
                if ((cmd.getCommand() instanceof IPostCommand || post) && !CommandHandlerEnum.FILEUPLOAD.equals((Object)cmd) && !CommandHandlerEnum.QUICKUPLOAD.equals((Object)cmd)) {
                    this.checkPostRequest(request);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            BeforeExecuteCommandEventArgs args = new BeforeExecuteCommandEventArgs();
            args.setCommand(command);
            args.setRequest(request);
            args.setResponse(response);
            if (configuration.getEvents() != null) {
                if (configuration.getEvents().run(Events.EventTypes.BeforeExecuteCommand, args, configuration)) {
                    cmd = CommandHandlerEnum.valueOf(command.toUpperCase());
                    cmd.execute(request, response, configuration, this.getServletContext(), new Object[0]);
                }
            } else {
                cmd = CommandHandlerEnum.valueOf(command.toUpperCase());
                cmd.execute(request, response, configuration, this.getServletContext(), new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
                e.printStackTrace();
                response.reset();
                throw new ServletException((Throwable)e);
            }
            this.handleError(new ConnectorException(10, false), configuration, request, response, command);
        }
        catch (ConnectorException e) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue() && e.getException() != null) {
                e.getException().printStackTrace();
                response.reset();
                throw new ServletException((Throwable)e.getException());
            }
            this.handleError(e, configuration, request, response, command);
        }
        catch (Exception e) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
                e.printStackTrace();
                response.reset();
                throw new ServletException((Throwable)e);
            }
            this.handleError(new ConnectorException(e), configuration, request, response, command);
        }
    }

    private void checkPostRequest(HttpServletRequest request) throws ConnectorException {
        if (request.getParameter("CKFinderCommand") == null || !request.getParameter("CKFinderCommand").equals("true")) {
            throw new ConnectorException(109, true);
        }
    }

    private void handleError(ConnectorException e, IConfiguration configuration, HttpServletRequest request, HttpServletResponse response, String currentCommand) throws ServletException {
        try {
            if (currentCommand != null) {
                Command command = CommandHandlerEnum.valueOf(currentCommand.toUpperCase()).getCommand();
                if (command instanceof XMLCommand) {
                    CommandHandlerEnum.XMLERROR.execute(request, response, configuration, this.getServletContext(), new Object[]{e});
                } else {
                    CommandHandlerEnum.ERROR.execute(request, response, configuration, this.getServletContext(), new Object[]{e});
                }
            } else {
                CommandHandlerEnum.XMLERROR.execute(request, response, configuration, this.getServletContext(), new Object[]{e});
            }
        }
        catch (Exception e1) {
            throw new ServletException((Throwable)e1);
        }
    }

    public void init() throws ServletException {
        ServletContextFactory.setServletContext(this.getServletContext());
        IConfiguration configuration = null;
        try {
            String className = this.getServletConfig().getInitParameter("configuration");
            if (className != null) {
                Class<?> clazz = Class.forName(className);
                configuration = clazz.getConstructor(ServletConfig.class) != null ? (IConfiguration)clazz.getConstructor(ServletConfig.class).newInstance(this.getServletConfig()) : (IConfiguration)clazz.newInstance();
            } else {
                configuration = new Configuration(this.getServletConfig());
            }
        }
        catch (Exception e) {
            configuration = new Configuration(this.getServletConfig());
        }
        try {
            configuration.init();
            AccessControlUtil.getInstance(configuration).loadACLConfig();
        }
        catch (Exception e) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
                e.printStackTrace();
            }
            this.startException = e;
            configuration = null;
        }
        ConfigurationFactory.getInstace().setConfiguration(configuration);
    }

    private static enum CommandHandlerEnum {
        INIT(new InitCommand()),
        GETFOLDERS(new GetFoldersCommand()),
        GETFILES(new GetFilesCommand()),
        LOADCOOKIES(new LoadCookiesCommand()),
        THUMBNAIL(new ThumbnailCommand()),
        DOWNLOADFILE(new DownloadFileCommand()),
        CREATEFOLDER(new CreateFolderCommand()),
        RENAMEFILE(new RenameFileCommand()),
        RENAMEFOLDER(new RenameFolderCommand()),
        DELETEFOLDER(new DeleteFolderCommand()),
        COPYFILES(new CopyFilesCommand()),
        MOVEFILES(new MoveFilesCommand()),
        DELETEFILES(new DeleteFilesCommand()),
        FILEUPLOAD(new FileUploadCommand()),
        QUICKUPLOAD(new QuickUploadCommand()),
        XMLERROR(new XMLErrorCommand()),
        ERROR(new ErrorCommand());

        private Command command;

        private CommandHandlerEnum(Command command1) {
            this.command = command1;
        }

        private void execute(HttpServletRequest request, HttpServletResponse response, IConfiguration configuration, ServletContext sc, Object ... params) throws ConnectorException {
            Command com = null;
            try {
                com = (Command)this.command.getClass().newInstance();
            }
            catch (IllegalAccessException e1) {
                throw new ConnectorException(10);
            }
            catch (InstantiationException e1) {
                throw new ConnectorException(10);
            }
            if (com == null) {
                throw new ConnectorException(10);
            }
            com.runCommand(request, response, configuration, params);
        }

        public Command getCommand() {
            return this.command;
        }
    }
}

