/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.amazon.ion.IonContainer;
import com.amazon.ion.IonDatagram;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.ion.IonFactory;
import com.fasterxml.jackson.dataformat.ion.IonGenerator;
import com.fasterxml.jackson.dataformat.ion.IonParser;
import com.fasterxml.jackson.dataformat.ion.IonTimestampDeserializers;
import com.fasterxml.jackson.dataformat.ion.IonTimestampSerializers;
import com.fasterxml.jackson.dataformat.ion.PackageVersion;
import java.io.IOException;
import java.sql.Date;

public class IonObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public IonObjectMapper() {
        this(new IonFactory());
    }

    public IonObjectMapper(IonFactory f) {
        super((JsonFactory)f);
        f.setCodec((ObjectCodec)this);
        SimpleModule m = new SimpleModule("IonTimestampModule", PackageVersion.VERSION);
        m.addSerializer(java.util.Date.class, (JsonSerializer)new IonTimestampSerializers.IonTimestampJavaDateSerializer());
        m.addSerializer(Date.class, (JsonSerializer)new IonTimestampSerializers.IonTimestampSQLDateSerializer());
        m.addDeserializer(java.util.Date.class, (JsonDeserializer)new IonTimestampDeserializers.IonTimestampJavaDateDeserializer());
        m.addDeserializer(Date.class, (JsonDeserializer)new IonTimestampDeserializers.IonTimestampSQLDateDeserializer());
        this.registerModule((Module)m);
    }

    protected IonObjectMapper(IonObjectMapper src) {
        super((ObjectMapper)src);
    }

    public static Builder builder() {
        return new Builder(new IonObjectMapper());
    }

    public static Builder builder(IonFactory streamFactory) {
        return new Builder(new IonObjectMapper(streamFactory));
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(IonObjectMapper.class);
        return new IonObjectMapper(this);
    }

    public void setCreateBinaryWriters(boolean bin) {
        this.getFactory().setCreateBinaryWriters(bin);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public IonObjectMapper configure(IonGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public IonObjectMapper configure(IonParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public IonObjectMapper enable(IonGenerator.Feature f) {
        ((IonFactory)this._jsonFactory).enable(f);
        return this;
    }

    public IonObjectMapper enable(IonParser.Feature f) {
        ((IonFactory)this._jsonFactory).enable(f);
        return this;
    }

    public IonObjectMapper disable(IonGenerator.Feature f) {
        ((IonFactory)this._jsonFactory).disable(f);
        return this;
    }

    public IonObjectMapper disable(IonParser.Feature f) {
        ((IonFactory)this._jsonFactory).disable(f);
        return this;
    }

    public IonFactory getFactory() {
        return (IonFactory)this._jsonFactory;
    }

    public IonParser createParser(IonReader reader) throws IOException {
        this._assertNotNull("value", reader);
        IonParser p = this.getFactory().createParser(reader);
        this._deserializationConfig.initialize((JsonParser)p);
        return p;
    }

    public IonParser createParser(IonValue value) throws IOException {
        this._assertNotNull("value", value);
        IonParser p = this.getFactory().createParser(value);
        this._deserializationConfig.initialize((JsonParser)p);
        return p;
    }

    public IonGenerator createGenerator(IonWriter writer) throws IOException {
        this._assertNotNull("writer", writer);
        IonGenerator g = (IonGenerator)this.getFactory().createGenerator(writer);
        this._serializationConfig.initialize((JsonGenerator)g);
        return g;
    }

    public <T> T readValue(IonReader r, Class<T> valueType) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.createParser(r), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(IonReader r, TypeReference valueTypeRef) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.createParser(r), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(IonReader r, JavaType valueType) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.createParser(r), valueType);
    }

    public <T> T readValue(IonValue value, Class<T> valueType) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.createParser(value), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(IonValue value, TypeReference valueTypeRef) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.createParser(value), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(IonValue value, JavaType valueType) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.createParser(value), valueType);
    }

    public void writeValue(IonWriter w, Object value) throws IOException {
        this._writeValueAndClose((JsonGenerator)this.createGenerator(w), value);
    }

    public IonValue writeValueAsIonValue(Object value) throws IOException {
        IonFactory f = this.getFactory();
        IonDatagram container = f._system.newDatagram();
        try (IonWriter writer = f._system.newWriter((IonContainer)container);){
            this.writeValue(writer, value);
            IonValue result = container.get(0);
            result.removeFromContainer();
            IonValue ionValue = result;
            return ionValue;
        }
    }

    public static class Builder
    extends MapperBuilder<IonObjectMapper, Builder> {
        public Builder(IonObjectMapper m) {
            super((ObjectMapper)m);
        }
    }
}

