/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.java.emoji;

import com.github.binarywang.java.emoji.model.Emoji4Unicode;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmojiReader {
    private static final Logger logger = LoggerFactory.getLogger(EmojiReader.class);
    private static final String URL = "https://raw.githubusercontent.com/googlei18n/emoji4unicode/master/data/emoji4unicode.xml";
    private static final String TRIM_PATTERN = "[^0-9A-F]*";
    private Emoji4Unicode emoji = null;
    private Map<List<Integer>, String> sb2UnicodeMap = null;

    Emoji4Unicode read(boolean onlyFromLocal) {
        if (this.emoji != null) {
            return this.emoji;
        }
        long beginTime = System.currentTimeMillis();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.processAnnotations(Emoji4Unicode.class);
        if (onlyFromLocal) {
            logger.info("==============from local file==============");
            this.emoji = (Emoji4Unicode)xstream.fromXML(EmojiReader.class.getResourceAsStream("/emoji4unicode.xml"));
            return this.emoji;
        }
        try {
            this.emoji = (Emoji4Unicode)xstream.fromXML(new URL(URL));
            logger.info("==============from url==============");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.emoji != null) {
            String interval = new Interval(beginTime, System.currentTimeMillis()).toPeriod().toString().replace("PT", "").replace("M", "\u5206").replace("S", "\u79d2");
            logger.info("\u4ece\u7f51\u7edc\u8bfb\u53d6\u603b\u8017\u65f6\uff1a " + interval);
            return this.emoji;
        }
        logger.info("==============from local file==============");
        this.emoji = (Emoji4Unicode)xstream.fromXML(EmojiReader.class.getResourceAsStream("/emoji4unicode.xml"));
        return this.emoji;
    }

    public Map<List<Integer>, String> getSb2UnicodeMap() {
        if (this.sb2UnicodeMap != null) {
            return this.sb2UnicodeMap;
        }
        this.sb2UnicodeMap = Maps.newHashMap();
        Emoji4Unicode emoji4Unicode = this.read(false);
        for (Emoji4Unicode.Category category : emoji4Unicode.getCategories()) {
            List<Emoji4Unicode.SubCategory> subCategories = category.getSubCategories();
            if (subCategories == null) continue;
            for (Emoji4Unicode.SubCategory subCategory : subCategories) {
                List<Emoji4Unicode.Element> elements = subCategory.getElements();
                if (elements == null) continue;
                for (Emoji4Unicode.Element element : elements) {
                    ArrayList<Integer> fromCodePoints = new ArrayList<Integer>();
                    String fromValue = element.getSoftbank();
                    if (fromValue == null) continue;
                    if (fromValue.length() > 6) {
                        String[] froms;
                        for (String part : froms = fromValue.split("\\+")) {
                            fromCodePoints.add(Integer.parseInt(part.replaceAll(TRIM_PATTERN, ""), 16));
                        }
                    } else {
                        fromCodePoints.add(Integer.parseInt(fromValue.replaceAll(TRIM_PATTERN, ""), 16));
                    }
                    String toValue = element.getUnicode();
                    if (toValue == null) {
                        this.sb2UnicodeMap.put(fromCodePoints, null);
                        continue;
                    }
                    StringBuilder toBuilder = new StringBuilder();
                    if (toValue.length() > 6) {
                        String[] tos;
                        for (String part : tos = toValue.split("\\+")) {
                            toBuilder.append(Character.toChars(Integer.parseInt(part.replaceAll(TRIM_PATTERN, ""), 16)));
                        }
                    } else {
                        toBuilder.append(Character.toChars(Integer.parseInt(toValue.replaceAll(TRIM_PATTERN, ""), 16)));
                    }
                    this.sb2UnicodeMap.put(fromCodePoints, toBuilder.toString());
                }
            }
        }
        return this.sb2UnicodeMap;
    }
}

