/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.DefaultHttpRequest;
import com.github.dreamhead.moco.model.DefaultMutableHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;

public class HttpHandler {
    private static final int DEFAULT_STATUS = HttpResponseStatus.OK.code();
    private final ActualHttpServer server;

    public HttpHandler(ActualHttpServer server) {
        this.server = server;
    }

    public FullHttpResponse handleRequest(FullHttpRequest message) {
        HttpRequest request = DefaultHttpRequest.newRequest(message);
        DefaultMutableHttpResponse httpResponse = this.getHttpResponse(request);
        FullHttpResponse response = httpResponse.toFullResponse();
        this.prepareForKeepAlive(message, response);
        return response;
    }

    private DefaultMutableHttpResponse getHttpResponse(HttpRequest request) {
        DefaultMutableHttpResponse httpResponse = DefaultMutableHttpResponse.newResponse(request, DEFAULT_STATUS);
        SessionContext context = new SessionContext(request, httpResponse);
        return this.doGetResponse(request, context);
    }

    private DefaultMutableHttpResponse doGetResponse(HttpRequest request, SessionContext context) {
        try {
            return (DefaultMutableHttpResponse)this.server.getResponse(context).orElse(DefaultMutableHttpResponse.newResponse(request, HttpResponseStatus.BAD_REQUEST.code()));
        }
        catch (RuntimeException e) {
            return DefaultMutableHttpResponse.newResponse(request, HttpResponseStatus.BAD_REQUEST.code());
        }
        catch (Exception e) {
            return DefaultMutableHttpResponse.newResponse(request, HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        }
    }

    private void setContentLengthForKeepAlive(FullHttpResponse response) {
        if (!HttpUtil.isContentLengthSet((HttpMessage)response)) {
            HttpUtil.setContentLength((HttpMessage)response, (long)response.content().writerIndex());
        }
    }

    private void prepareForKeepAlive(FullHttpRequest request, FullHttpResponse response) {
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
            this.setContentLengthForKeepAlive(response);
        }
    }
}

