/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.matcher.AbstractRequestMatcher;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.Resource;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractOperatorMatcher<T>
extends AbstractRequestMatcher {
    private final RequestExtractor<T> extractor;
    private final Resource expected;
    private final Predicate<String> predicate;

    protected abstract RequestMatcher newMatcher(RequestExtractor<T> var1, Resource var2);

    protected AbstractOperatorMatcher(RequestExtractor<T> extractor, Resource expected, Predicate<String> predicate) {
        this.extractor = extractor;
        this.predicate = predicate;
        this.expected = expected;
    }

    @Override
    public final boolean match(Request request) {
        Optional<T> extractContent = this.extractor.extract(request);
        if (!extractContent.isPresent()) {
            return false;
        }
        T target = extractContent.get();
        if (target instanceof String) {
            return this.predicate.test((String)target);
        }
        if (target instanceof String[]) {
            String[] contents = (String[])target;
            return Arrays.stream(contents).filter(Objects::nonNull).anyMatch(this.predicate);
        }
        if (target instanceof MessageContent) {
            MessageContent actualTarget = (MessageContent)target;
            return this.predicate.test(actualTarget.toString());
        }
        return false;
    }

    @Override
    public final RequestMatcher doApply(MocoConfig config) {
        Resource appliedResource = this.expected.apply(config);
        if (appliedResource == this.expected) {
            return this;
        }
        return this.newMatcher(this.extractor, appliedResource);
    }
}

