/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.recorder;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.mount.AbstractHttpContentResponseHandler;
import com.github.dreamhead.moco.recorder.RecordHandler;
import com.github.dreamhead.moco.recorder.RecorderConfigurations;
import com.github.dreamhead.moco.recorder.RecorderIdentifier;
import com.github.dreamhead.moco.recorder.RecorderRegistry;
import com.github.dreamhead.moco.recorder.RequestRecorder;
import com.google.common.net.MediaType;

public class DynamicRecordHandler
extends AbstractHttpContentResponseHandler
implements RecordHandler {
    private final RecorderRegistry registry;
    private final RecorderIdentifier identifier;

    public DynamicRecordHandler(RecorderConfigurations configurations) {
        this.registry = configurations.getRecorderRegistry();
        this.identifier = configurations.getIdentifier();
    }

    @Override
    protected final MessageContent responseContent(HttpRequest httpRequest) {
        RequestRecorder recorder = this.getRequestRecorder(httpRequest);
        recorder.record(httpRequest);
        return MessageContent.content().build();
    }

    private RequestRecorder getRequestRecorder(HttpRequest httpRequest) {
        return this.registry.recorderOf(this.identifier.getIdentifier(httpRequest));
    }

    @Override
    protected final MediaType getContentType(HttpRequest request) {
        return MediaType.PLAIN_TEXT_UTF_8;
    }
}

