/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.reader.AbstractFileResourceReader;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;

public final class ClasspathFileResourceReader
extends AbstractFileResourceReader {
    public ClasspathFileResourceReader(Resource filename, Charset charset) {
        super(filename, charset);
    }

    @Override
    protected byte[] doReadFor(Request request) {
        String actualFilename = this.filename(request);
        URL resource = Resources.getResource((String)actualFilename);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("%s does not exist", actualFilename));
        }
        try {
            return ByteStreams.toByteArray((InputStream)resource.openStream());
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }
}

