/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.util.Functions;
import com.github.dreamhead.moco.util.Jsons;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Function;

public final class JsonResourceReader
implements ContentResourceReader {
    private final Function<Request, Object> function;

    public JsonResourceReader(Function<Request, Object> function) {
        this.function = function;
    }

    @Override
    public MediaType getContentType(HttpRequest request) {
        return MediaType.create((String)"application", (String)"json").withCharset(Charset.defaultCharset());
    }

    @Override
    public MessageContent readFor(Request request) {
        Object value = Functions.checkApply(this.function, request);
        if (value instanceof String) {
            return MessageContent.content((String)value);
        }
        if (value instanceof Resource) {
            Resource resource = (Resource)value;
            return resource.readFor(request);
        }
        if (value instanceof InputStream) {
            return MessageContent.content().withContent((InputStream)value).build();
        }
        return MessageContent.content().withContent(Jsons.toJson(value)).build();
    }

    public Object getPojo() {
        return this.function.apply(null);
    }
}

