/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.util.Preconditions;
import com.github.dreamhead.moco.util.URLs;

public final class RestIdMatchers {
    public static RestIdMatcher anyId() {
        return new BaseRestIdMatcher("[^/]*");
    }

    public static RestIdMatcher eq(String id) {
        return new BaseRestIdMatcher(Preconditions.checkNotNullOrEmpty(id, "ID should not be null or empty"));
    }

    public static RestIdMatcher match(String uri) {
        return new BaseRestIdMatcher(Preconditions.checkNotNullOrEmpty(uri, "Match target should not be null or empty"));
    }

    private RestIdMatchers() {
    }

    private static class BaseRestIdMatcher
    implements RestIdMatcher {
        private final String uriPart;

        BaseRestIdMatcher(String uriPart) {
            this.uriPart = uriPart;
        }

        @Override
        public String resourceUri() {
            return this.uriPart;
        }

        @Override
        public RequestMatcher matcher(RestIdMatcher resourceName) {
            return Moco.match(Moco.uri(this.subResourceUri(resourceName)));
        }

        private String subResourceUri(RestIdMatcher resourceName) {
            return URLs.join(URLs.resourceRoot(resourceName.resourceUri()), this.uriPart);
        }
    }
}

