/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public final class Iterables {
    public static <T> List<T> asIterable(T handler, T[] handlers) {
        Preconditions.checkNotNull(handler);
        Preconditions.checkNotNull(handlers);
        if (handlers.length == 0) {
            return ImmutableList.of(handler);
        }
        return ImmutableList.builder().add(handler).add((Object[])handlers).build();
    }

    public static <T> List<T> asIterable(T handler, T handler2, T[] handlers) {
        Preconditions.checkNotNull(handler);
        Preconditions.checkNotNull(handler2);
        Preconditions.checkNotNull(handlers);
        if (handlers.length == 0) {
            return ImmutableList.of(handler, handler2);
        }
        return ImmutableList.builder().add(handler).add(handler2).add((Object[])handlers).build();
    }

    public static <T> T head(T[] elements) {
        Preconditions.checkNotNull(elements);
        if (elements.length == 0) {
            return null;
        }
        return elements[0];
    }

    public static <T> T[] tail(T[] elements) {
        Preconditions.checkNotNull(elements);
        if (elements.length <= 1) {
            return (Object[])Array.newInstance(elements.getClass().getComponentType(), 0);
        }
        return Arrays.copyOfRange(elements, 1, elements.length);
    }

    public static <T> boolean isNullOrEmpty(Iterable<T> iterable) {
        return iterable == null || com.google.common.collect.Iterables.isEmpty(iterable);
    }

    private Iterables() {
    }
}

