/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.websocket;

import com.github.dreamhead.moco.recorder.MocoGroup;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import java.util.Collection;
import java.util.Map;

public class ChannelSessionGroup {
    private final ChannelGroup group;
    private Multimap<MocoGroup, Channel> groupChannels;
    private Map<Channel, MocoGroup> channelGroups;

    public ChannelSessionGroup(ChannelGroup group) {
        this.group = group;
        this.groupChannels = HashMultimap.create();
        this.channelGroups = Maps.newHashMap();
    }

    public void add(Channel channel) {
        this.group.add((Object)channel);
    }

    public void remove(Channel channel) {
        this.group.remove((Object)channel);
        MocoGroup group = this.channelGroups.get(channel);
        if (group != null) {
            this.channelGroups.remove(channel);
            this.groupChannels.remove((Object)group, (Object)channel);
        }
    }

    public void writeAndFlush(Object message, MocoGroup group) {
        if (group == null) {
            this.group.writeAndFlush(message);
            return;
        }
        Collection channels = this.groupChannels.get((Object)group);
        for (Channel channel : channels) {
            channel.writeAndFlush(message);
        }
    }

    public void join(MocoGroup group, Channel channel) {
        this.groupChannels.put((Object)group, (Object)channel);
        this.channelGroups.put(channel, group);
    }
}

