/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.replace;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.CharsScanMatchItem;
import com.github.houbb.chars.scan.api.ICharsReplace;
import com.github.houbb.chars.scan.util.InnerCharUtil;
import com.github.houbb.chars.scan.util.InnerStringCoding;
import java.nio.charset.Charset;

public abstract class AbstractCharReplace
implements ICharsReplace {
    public abstract void doReplace(StringBuilder var1, char[] var2, CharsScanMatchItem var3, CharsScanContext var4);

    @Override
    public void replace(StringBuilder stringBuilder, char[] chars, CharsScanMatchItem charsScanMatchItem, CharsScanContext context) {
        if (this.ignoreReplace(chars, charsScanMatchItem)) {
            InnerCharUtil.appendChars(stringBuilder, chars, charsScanMatchItem.getStartIndex(), charsScanMatchItem.getEndIndex());
            return;
        }
        this.doReplace(stringBuilder, chars, charsScanMatchItem, context);
        byte[] bytes = InnerStringCoding.encode(Charset.forName("UTF-8"), chars, charsScanMatchItem.getStartIndex(), charsScanMatchItem.getLength());
        context.getCharsReplaceHash().hash(bytes, context, stringBuilder);
    }

    protected boolean ignoreReplace(char[] chars, CharsScanMatchItem charsScanMatchItem) {
        return false;
    }

    protected void replaceByIndex(StringBuilder stringBuilder, char[] chars, CharsScanMatchItem charsScanMatchItem, CharsScanContext context, int maskStartIndex, int maskEndIndex) {
        int startIndex = charsScanMatchItem.getStartIndex();
        int endIndex = charsScanMatchItem.getEndIndex();
        if (maskStartIndex > startIndex) {
            InnerCharUtil.appendChars(stringBuilder, chars, startIndex, maskStartIndex - 1);
        }
        for (int i = maskStartIndex; i <= maskEndIndex; ++i) {
            stringBuilder.append('*');
        }
        if (maskEndIndex < endIndex) {
            InnerCharUtil.appendChars(stringBuilder, chars, maskEndIndex + 1, endIndex);
        }
    }
}

