/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractExpandConditionCharScan;
import com.github.houbb.heaven.util.lang.CharUtil;
import java.util.HashSet;
import java.util.Set;

public class AddressExpandConditionCharScan
extends AbstractExpandConditionCharScan {
    private static final Set<Character> PLACE_CHAR_SET;

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.ADDRESS.getPriority();
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.ADDRESS.getScanType();
    }

    @Override
    protected CharsScanTypeEnum isExpandStartCharCondition(int i, char c, char[] chars, CharsScanContext context) {
        if (PLACE_CHAR_SET.contains(Character.valueOf(c))) {
            return CharsScanTypeEnum.ADDRESS;
        }
        return null;
    }

    @Override
    protected boolean isLeftExpandMatchCondition(int leftIx, char leftChar, char[] chars, CharsScanContext context) {
        if (leftIx == 0) {
            return CharUtil.isChinese((char)leftChar);
        }
        return CharUtil.isChinese((char)leftChar) || CharUtil.isDigitOrLetter((char)leftChar) || '-' == leftChar;
    }

    @Override
    protected boolean isRightExpandMatchCondition(int rightIx, char rightChar, char[] chars, CharsScanContext context) {
        return CharUtil.isChinese((char)rightChar) || CharUtil.isDigitOrLetter((char)rightChar) || '-' == rightChar;
    }

    @Override
    protected boolean isLeftBufferMatch(int middleIx, int startIx, char[] chars, CharsScanContext context) {
        int len = middleIx - startIx;
        return len >= 1 && len <= 100;
    }

    @Override
    protected boolean isRightBufferMatch(int middleIx, int startIx, int endIx, char[] chars, CharsScanContext context) {
        int len = endIx - startIx;
        return len >= 6 && len <= 100;
    }

    static {
        String keywords = "\u56fd\u7701\u5e02\u53bf\u533a\u8def\u9547\u4e61\u6751\u8857\u9053\u56ed\u9662\u91cc\u5382\u5f04";
        PLACE_CHAR_SET = new HashSet<Character>(keywords.length());
        for (char c : keywords.toCharArray()) {
            PLACE_CHAR_SET.add(Character.valueOf(c));
        }
    }
}

