/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.heaven.util.lang.CharUtil;

public class PassportConditionCharScan
extends AbstractConditionCharScan {
    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return CharUtil.isNumber((char)c) || CharUtil.isEnglish((char)c);
    }

    @Override
    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        int bufferLen = super.getBuffer().length();
        if (bufferLen != 9) {
            return false;
        }
        int startIx = i - bufferLen;
        if (!CharUtil.isEnglish((char)chars[startIx])) {
            return false;
        }
        for (int j = startIx + 2; j < i; ++j) {
            if (!CharUtil.isNotNumber((char)chars[j])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.PASSPORT.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.PASSPORT.getPriority();
    }
}

