/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.util;

import com.github.houbb.chars.scan.util.InnerCharUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InnerIdNoHelper {
    private static final String PROVINCE_CODES = "11,12,13,14,15,21,22,23,31,32,33,34,35,36,37,41,42,43,44,45,46,50,51,52,53,54,61,62,63,64,65";
    private static final Map<Character, Set<Character>> AREA_MAP;
    private static final int[] CHECK_WEIGHT;
    private static final char[] CHECK_MAPPING;

    public static boolean isValidIdNo(StringBuilder buffer) {
        char check;
        int len = buffer.length();
        if (len != 18) {
            return false;
        }
        if (!InnerIdNoHelper.isValidAreaCode(buffer)) {
            return false;
        }
        if (!InnerCharUtil.isValidDate(buffer, 6)) {
            return false;
        }
        char lastChar = buffer.charAt(17);
        if (lastChar == 'x') {
            lastChar = 'X';
        }
        return (check = InnerIdNoHelper.getCheckDigit(buffer)) == lastChar;
    }

    public static boolean isValidAreaCode(StringBuilder stringBuilder) {
        Set<Character> characters = AREA_MAP.get(Character.valueOf(stringBuilder.charAt(0)));
        if (characters == null) {
            return false;
        }
        return characters.contains(Character.valueOf(stringBuilder.charAt(1)));
    }

    public static char getCheckDigit(StringBuilder stringBuilder) {
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            int weight = CHECK_WEIGHT[i] * InnerCharUtil.getCharInt(stringBuilder.charAt(i));
            sum += weight;
        }
        int value = sum % 11;
        return CHECK_MAPPING[value];
    }

    static {
        String[] codes;
        AREA_MAP = new HashMap<Character, Set<Character>>();
        CHECK_WEIGHT = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        CHECK_MAPPING = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        for (String code : codes = PROVINCE_CODES.split(",")) {
            char firstChar = code.charAt(0);
            char secondChar = code.charAt(1);
            Set<Character> characters = AREA_MAP.get(Character.valueOf(firstChar));
            if (characters == null) {
                characters = new HashSet<Character>();
            }
            characters.add(Character.valueOf(secondChar));
            AREA_MAP.put(Character.valueOf(firstChar), characters);
        }
    }
}

