/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.core.impl;

import com.github.houbb.heaven.support.attr.impl.AttributeContext;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.property.core.IProperty;
import com.github.houbb.property.exception.PropertyRuntimeException;
import com.github.houbb.property.support.properties.OrderedProperties;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SimpleProperty
extends AttributeContext
implements IProperty {
    @Override
    public synchronized IProperty load(InputStream inputStream, String charset) {
        try {
            Properties properties = new Properties();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
            properties.load(inputStreamReader);
            int size = properties.keySet().size();
            HashMap<String, Object> map = new HashMap<String, Object>(size);
            for (Object key : properties.keySet()) {
                map.put(String.valueOf(key), properties.get(key));
            }
            super.putAttrMap(map);
            SimpleProperty simpleProperty = this;
            return simpleProperty;
        }
        catch (IOException e) {
            throw new PropertyRuntimeException(e);
        }
        finally {
            StreamUtil.closeStream((Closeable)inputStream);
        }
    }

    @Override
    public synchronized IProperty flush(OutputStream outputStream, String charset) {
        OrderedProperties properties = new OrderedProperties();
        try {
            for (Map.Entry entry : super.entrySet()) {
                ((Properties)properties).put(entry.getKey(), entry.getValue());
            }
            properties.store(outputStream, null);
            SimpleProperty simpleProperty = this;
            return simpleProperty;
        }
        catch (IOException e) {
            throw new PropertyRuntimeException(e);
        }
        finally {
            StreamUtil.closeStream((Closeable)outputStream);
        }
    }

    @Override
    public IProperty putAttr(Map<String, String> map) {
        super.putAttrMap(map);
        return this;
    }

    @Override
    public Map<String, String> asMap() {
        Set entrySet = super.entrySet();
        if (CollectionUtil.isEmpty((Collection)entrySet)) {
            return Guavas.newHashMap();
        }
        Map resultMap = Guavas.newHashMap((int)entrySet.size());
        for (Map.Entry entry : entrySet) {
            String value = ObjectUtil.objectToString(entry.getValue());
            resultMap.put(entry.getKey(), value);
        }
        return resultMap;
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        Set entrySet = super.entrySet();
        for (Map.Entry entry : entrySet) {
            String value = ObjectUtil.objectToString(entry.getValue());
            properties.setProperty((String)entry.getKey(), value);
        }
        return properties;
    }
}

