/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.support.bean.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.model.PropertyBo;
import com.github.houbb.property.support.bean.IBeanToMap;
import com.github.houbb.property.support.bean.impl.PropertyBos;
import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.context.PropertyValueContext;
import java.lang.reflect.Field;
import java.util.Map;

@ThreadSafe
public class BeanToMap
implements IBeanToMap {
    @Override
    public Map<String, String> beanToMap(Object bean) {
        Map valueMap = Guavas.newHashMap();
        this.beanToMapWithEntry("", bean, valueMap);
        return valueMap;
    }

    private void beanToMapWithEntry(String prefix, Object bean, Map<String, String> valueMap) {
        Map<String, PropertyBo> propertyBoMap = PropertyBos.buildPropertyBoMap(bean);
        if (MapUtil.isEmpty(propertyBoMap)) {
            return;
        }
        for (Map.Entry<String, PropertyBo> entry : propertyBoMap.entrySet()) {
            String propertyName = prefix + entry.getKey();
            PropertyBo propertyBo = entry.getValue();
            Field field = propertyBo.field();
            Object fieldValue = ReflectFieldUtil.getValue((Field)field, (Object)bean);
            PropertyEntry propertyEntry = propertyBo.propertyEntry();
            if (ObjectUtil.isNotNull((Object)propertyEntry)) {
                String prefixNew = propertyName + ".";
                this.beanToMapWithEntry(prefixNew, fieldValue, valueMap);
                continue;
            }
            PropertyValueContext context = PropertyValueContext.newInstance();
            context.field(field).fieldName(propertyBo.fieldName()).propertyName(propertyName).object(bean).propertyField(propertyBo.propertyField()).propertyFormat(propertyBo.propertyFormat()).format(propertyBo.format());
            IValueConverter converter = propertyBo.converter();
            String propertyValue = converter.propertyValue(fieldValue, context);
            valueMap.put(propertyName, propertyValue);
        }
    }
}

