/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.support.bean.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.model.PropertyBo;
import com.github.houbb.property.support.bean.IMapToBean;
import com.github.houbb.property.support.bean.impl.PropertyBos;
import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.context.FieldValueContext;
import java.lang.reflect.Field;
import java.util.Map;

@ThreadSafe
public class MapToBean
implements IMapToBean {
    @Override
    public void mapToBean(Map<String, String> valueMap, Object bean) {
        if (MapUtil.isEmpty(valueMap)) {
            return;
        }
        this.mapToBeanWithEntry("", valueMap, bean);
    }

    private void mapToBeanWithEntry(String prefix, Map<String, String> valueMap, Object bean) {
        Map<String, PropertyBo> propertyBoMap = PropertyBos.buildPropertyBoMap(bean);
        if (MapUtil.isEmpty(propertyBoMap)) {
            return;
        }
        for (Map.Entry<String, PropertyBo> entry : propertyBoMap.entrySet()) {
            String propertyName = prefix + entry.getKey();
            PropertyBo propertyBo = entry.getValue();
            Field field = propertyBo.field();
            Class<?> fieldType = field.getType();
            PropertyEntry propertyEntry = propertyBo.propertyEntry();
            if (ObjectUtil.isNotNull((Object)propertyEntry)) {
                String prefixNew = propertyName + ".";
                Object fieldValue = ClassUtil.newInstance(fieldType);
                this.mapToBeanWithEntry(prefixNew, valueMap, fieldValue);
                ReflectFieldUtil.setValue((Field)field, (Object)bean, (Object)fieldValue);
                continue;
            }
            if (!valueMap.containsKey(propertyName)) continue;
            String value = valueMap.get(propertyName);
            IValueConverter converter = propertyBo.converter();
            FieldValueContext context = FieldValueContext.newInstance();
            context.field(field).fieldName(propertyBo.fieldName()).propertyName(propertyName).object(bean).propertyField(propertyBo.propertyField()).propertyFormat(propertyBo.propertyFormat()).format(propertyBo.format());
            Object fieldValue = converter.fieldValue(value, context);
            ReflectFieldUtil.setValue((Field)field, (Object)bean, (Object)fieldValue);
        }
    }
}

