/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.support.bean.impl;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.annotation.PropertyField;
import com.github.houbb.property.annotation.PropertyFormat;
import com.github.houbb.property.model.PropertyBo;
import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.factory.ValueConverterFactory;
import com.github.houbb.property.support.converter.impl.DefaultValueConverter;
import java.lang.reflect.Field;
import java.util.Map;

final class PropertyBos {
    private PropertyBos() {
    }

    static Map<String, PropertyBo> buildPropertyBoMap(Object bean) {
        if (ObjectUtil.isNull((Object)bean)) {
            return Guavas.newHashMap();
        }
        Map fieldMap = ClassUtil.getAllFieldMap(bean.getClass());
        if (MapUtil.isEmpty((Map)fieldMap)) {
            return Guavas.newHashMap();
        }
        Map resultMap = Guavas.newHashMap((int)fieldMap.size());
        for (Map.Entry entry : fieldMap.entrySet()) {
            String value;
            String fieldName = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            String propertyName = fieldName;
            Class converterClass = DefaultValueConverter.class;
            PropertyField propertyField = null;
            if (field.isAnnotationPresent(PropertyField.class)) {
                propertyField = field.getAnnotation(PropertyField.class);
                String value2 = propertyField.value();
                if (StringUtil.isNotEmpty((String)value2)) {
                    propertyName = value2;
                }
                converterClass = propertyField.converter();
            }
            PropertyEntry propertyEntry = null;
            if (field.isAnnotationPresent(PropertyEntry.class) && StringUtil.isNotEmpty((String)(value = (propertyEntry = field.getAnnotation(PropertyEntry.class)).value()))) {
                propertyName = value;
            }
            PropertyFormat propertyFormat = null;
            String format = null;
            if (field.isAnnotationPresent(PropertyFormat.class)) {
                propertyFormat = field.getAnnotation(PropertyFormat.class);
                format = propertyFormat.value();
            }
            IValueConverter valueConverter = ValueConverterFactory.getConverter(converterClass);
            PropertyBo propertyBo = PropertyBo.newInstance().field(field).propertyField(propertyField).propertyName(propertyName).converter(valueConverter).propertyEntry(propertyEntry).parentObject(bean).fieldName(fieldName).propertyFormat(propertyFormat).format(format);
            resultMap.put(propertyName, propertyBo);
        }
        return resultMap;
    }
}

