/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.support.converter.impl.util;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.DateUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;
import java.util.Date;

public class DateValueConverter
extends AbstractValueConverter<Date> {
    @Override
    protected Date getFieldValue(String value, IFieldValueContext context) {
        String format = context.format();
        if (StringUtil.isNotEmpty((String)format)) {
            return DateUtil.getFormatDate((String)value, (String)format);
        }
        return new Date(Long.parseLong(value));
    }

    @Override
    protected String getPropertyValue(Date value, IPropertyValueContext context) {
        String format = context.format();
        if (StringUtil.isNotEmpty((String)format)) {
            return DateUtil.getDateFormat((Date)value, (String)format);
        }
        return String.valueOf(value.getTime());
    }
}

