/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.trie.impl;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.trie.api.ICharIter;
import com.github.houbb.trie.api.ITrieTree;
import com.github.houbb.trie.support.iter.ArrayCharIter;
import com.github.houbb.trie.support.iter.StringBuilderCharIter;
import com.github.houbb.trie.support.iter.StringCharIter;
import java.util.Collection;

public abstract class AbstractTrieTree
implements ITrieTree {
    @Override
    public void insert(Collection<String> words) {
        if (CollectionUtil.isEmpty(words)) {
            return;
        }
        for (String word : words) {
            this.insert(word);
        }
    }

    @Override
    public void insert(String word) {
        if (StringUtil.isEmpty((String)word)) {
            return;
        }
        this.insert(new StringCharIter(word));
    }

    @Override
    public boolean search(String word) {
        if (StringUtil.isEmpty((String)word)) {
            return false;
        }
        return this.search(new StringCharIter(word));
    }

    @Override
    public boolean startsWith(String prefix) {
        if (StringUtil.isEmpty((String)prefix)) {
            return false;
        }
        return this.startsWith(new StringCharIter(prefix));
    }

    protected abstract void doInsert(ICharIter var1);

    @Override
    public void insert(ICharIter charIter) {
        if (charIter == null) {
            return;
        }
        this.doInsert(charIter);
    }

    protected abstract boolean doSearch(ICharIter var1);

    @Override
    public boolean search(ICharIter charIter) {
        if (charIter == null) {
            return false;
        }
        return this.doSearch(charIter);
    }

    protected abstract boolean doStartsWith(ICharIter var1);

    @Override
    public boolean startsWith(ICharIter charIter) {
        if (charIter == null) {
            return false;
        }
        return this.doStartsWith(charIter);
    }

    @Override
    public void insert(char[] word) {
        if (ArrayPrimitiveUtil.isEmpty((char[])word)) {
            return;
        }
        this.insert(new ArrayCharIter(word));
    }

    @Override
    public boolean search(char[] word) {
        if (ArrayPrimitiveUtil.isEmpty((char[])word)) {
            return false;
        }
        return this.search(new ArrayCharIter(word));
    }

    @Override
    public boolean startsWith(char[] prefix) {
        if (ArrayPrimitiveUtil.isEmpty((char[])prefix)) {
            return false;
        }
        return this.startsWith(new ArrayCharIter(prefix));
    }

    @Override
    public void insert(StringBuilder word) {
        if (word == null) {
            return;
        }
        this.insert(new StringBuilderCharIter(word));
    }

    @Override
    public boolean search(StringBuilder word) {
        if (word == null) {
            return false;
        }
        return this.search(new StringBuilderCharIter(word));
    }

    @Override
    public boolean startsWith(StringBuilder prefix) {
        if (prefix == null) {
            return false;
        }
        return this.startsWith(new StringBuilderCharIter(prefix));
    }
}

