/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.kit;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ijpay.core.IJPayHttpResponse;
import com.ijpay.core.enums.AuthTypeEnum;
import com.ijpay.core.enums.RequestMethodEnum;
import com.ijpay.core.enums.SignType;
import com.ijpay.core.kit.AesUtil;
import com.ijpay.core.kit.PayKit;
import com.ijpay.core.kit.RsaKit;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WxPayKit {
    private static final String FIELD_SIGN = "sign";
    private static final String FIELD_SIGN_TYPE = "sign_type";

    public static String hmacSha256(String data, String key) {
        return PayKit.hmacSha256(data, key);
    }

    public static String md5(String data) {
        return PayKit.md5(data);
    }

    public static String decryptData(String base64Data, String key) {
        return PayKit.decryptData(base64Data, key);
    }

    public static String encryptData(String data, String key) {
        return PayKit.encryptData(data, key);
    }

    public static String generateStr() {
        return PayKit.generateStr();
    }

    public static boolean verifyNotify(Map<String, String> params, String partnerKey) {
        String sign = params.get(FIELD_SIGN);
        String localSign = WxPayKit.createSign(params, partnerKey, SignType.MD5);
        return sign.equals(localSign);
    }

    public static boolean verifyNotify(Map<String, String> params, String partnerKey, SignType signType, String signKey) {
        if (StrUtil.isEmpty((CharSequence)signKey)) {
            signKey = FIELD_SIGN;
        }
        String sign = params.get(signKey);
        String localSign = WxPayKit.createSign(params, partnerKey, signType, signKey);
        return sign.equals(localSign);
    }

    public static boolean verifyNotify(Map<String, String> params, String partnerKey, String signKey) {
        return WxPayKit.verifyNotify(params, partnerKey, SignType.MD5, signKey);
    }

    public static boolean verifyNotify(Map<String, String> params, String partnerKey, SignType signType) {
        return WxPayKit.verifyNotify(params, partnerKey, signType, null);
    }

    public static String createSign(Map<String, String> params, String partnerKey, SignType signType) {
        return WxPayKit.createSign(params, partnerKey, signType, null);
    }

    public static String createSign(Map<String, String> params, String partnerKey, SignType signType, String signKey) {
        if (signType == null) {
            signType = SignType.MD5;
        }
        if (StrUtil.isEmpty((CharSequence)signKey)) {
            signKey = FIELD_SIGN;
        }
        params.remove(signKey);
        String tempStr = PayKit.createLinkString(params);
        String stringSignTemp = tempStr + "&key=" + partnerKey;
        if (signType == SignType.MD5) {
            return WxPayKit.md5(stringSignTemp).toUpperCase();
        }
        return WxPayKit.hmacSha256(stringSignTemp, partnerKey).toUpperCase();
    }

    public static String createSign(Map<String, String> params, String secret) {
        params.remove(FIELD_SIGN);
        String tempStr = PayKit.createLinkString(params);
        String stringSignTemp = tempStr + "&secret=" + secret;
        return WxPayKit.md5(stringSignTemp).toUpperCase();
    }

    public static Map<String, String> buildSign(Map<String, String> params, String partnerKey, SignType signType) {
        return WxPayKit.buildSign(params, partnerKey, signType, true);
    }

    public static Map<String, String> buildSign(Map<String, String> params, String partnerKey, SignType signType, boolean haveSignType) {
        return WxPayKit.buildSign(params, partnerKey, signType, null, null, haveSignType);
    }

    public static Map<String, String> buildSign(Map<String, String> params, String partnerKey, SignType signType, String signKey, String signTypeKey, boolean haveSignType) {
        if (StrUtil.isEmpty((CharSequence)signKey)) {
            signKey = FIELD_SIGN;
        }
        if (haveSignType) {
            if (StrUtil.isEmpty((CharSequence)signTypeKey)) {
                signTypeKey = FIELD_SIGN_TYPE;
            }
            params.put(signTypeKey, signType.getType());
        }
        String sign = WxPayKit.createSign(params, partnerKey, signType);
        params.put(signKey, sign);
        return params;
    }

    public static StringBuffer forEachMap(Map<String, String> params, String prefix, String suffix) {
        return PayKit.forEachMap(params, prefix, suffix);
    }

    public static String toXml(Map<String, String> params) {
        return PayKit.toXml(params);
    }

    public static Map<String, String> xmlToMap(String xmlStr) {
        return PayKit.xmlToMap(xmlStr);
    }

    public static String bizPayUrl(String sign, String appId, String mchId, String productId, String timeStamp, String nonceStr) {
        String rules = "weixin://wxpay/bizpayurl?sign=Temp&appid=Temp&mch_id=Temp&product_id=Temp&time_stamp=Temp&nonce_str=Temp";
        return WxPayKit.replace(rules, "Temp", sign, appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String bizPayUrl(String partnerKey, String appId, String mchId, String productId, String timeStamp, String nonceStr, SignType signType) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("appid", appId);
        map.put("mch_id", mchId);
        map.put("time_stamp", StrUtil.isEmpty((CharSequence)timeStamp) ? Long.toString(System.currentTimeMillis() / 1000L) : timeStamp);
        map.put("nonce_str", StrUtil.isEmpty((CharSequence)nonceStr) ? WxPayKit.generateStr() : nonceStr);
        map.put("product_id", productId);
        return WxPayKit.bizPayUrl(WxPayKit.createSign(map, partnerKey, signType), appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String bizPayUrl(String partnerKey, String appId, String mchId, String productId) {
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonceStr = WxPayKit.generateStr();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("appid", appId);
        map.put("mch_id", mchId);
        map.put("time_stamp", timeStamp);
        map.put("nonce_str", nonceStr);
        map.put("product_id", productId);
        return WxPayKit.bizPayUrl(WxPayKit.createSign(map, partnerKey, null), appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String replace(String str, String regex, String ... args) {
        for (String arg : args) {
            str = str.replaceFirst(regex, arg);
        }
        return str;
    }

    public static boolean codeIsOk(String codeValue) {
        return StrUtil.isNotEmpty((CharSequence)codeValue) && "SUCCESS".equals(codeValue);
    }

    public static Map<String, String> prepayIdCreateSign(String prepayId, String appId, String partnerKey, SignType signType) {
        HashMap<String, String> packageParams = new HashMap<String, String>(6);
        packageParams.put("appId", appId);
        packageParams.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        packageParams.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("package", "prepay_id=" + prepayId);
        if (signType == null) {
            signType = SignType.MD5;
        }
        packageParams.put("signType", signType.getType());
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, signType);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static Map<String, String> jsApiCreateSign(String appId, String prepayId, String keyPath) throws Exception {
        return WxPayKit.jsApiCreateSign(appId, prepayId, PayKit.getPrivateKey(keyPath, AuthTypeEnum.RSA.getCode()));
    }

    public static Map<String, String> jsApiCreateSign(String appId, String prepayId, PrivateKey privateKey) throws Exception {
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = String.valueOf(System.currentTimeMillis());
        String packageStr = "prepay_id=" + prepayId;
        HashMap<String, String> packageParams = new HashMap<String, String>(6);
        packageParams.put("appId", appId);
        packageParams.put("timeStamp", timeStamp);
        packageParams.put("nonceStr", nonceStr);
        packageParams.put("package", packageStr);
        packageParams.put("signType", SignType.RSA.toString());
        ArrayList<String> list = new ArrayList<String>();
        list.add(appId);
        list.add(timeStamp);
        list.add(nonceStr);
        list.add(packageStr);
        String packageSign = PayKit.createSign(PayKit.buildSignMessage(list), privateKey);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static Map<String, String> appPrepayIdCreateSign(String appId, String partnerId, String prepayId, String partnerKey, SignType signType) {
        HashMap<String, String> packageParams = new HashMap<String, String>(8);
        packageParams.put("appid", appId);
        packageParams.put("partnerid", partnerId);
        packageParams.put("prepayid", prepayId);
        packageParams.put("package", "Sign=WXPay");
        packageParams.put("noncestr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        if (signType == null) {
            signType = SignType.MD5;
        }
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, signType);
        packageParams.put(FIELD_SIGN, packageSign);
        return packageParams;
    }

    public static Map<String, String> appCreateSign(String appId, String partnerId, String prepayId, String keyPath) throws Exception {
        return WxPayKit.appCreateSign(appId, partnerId, prepayId, PayKit.getPrivateKey(keyPath, AuthTypeEnum.RSA.getCode()));
    }

    public static Map<String, String> appCreateSign(String appId, String partnerId, String prepayId, PrivateKey privateKey) throws Exception {
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> packageParams = new HashMap<String, String>(8);
        packageParams.put("appid", appId);
        packageParams.put("partnerid", partnerId);
        packageParams.put("prepayid", prepayId);
        packageParams.put("package", "Sign=WXPay");
        packageParams.put("timestamp", timeStamp);
        packageParams.put("noncestr", nonceStr);
        packageParams.put("signType", SignType.RSA.toString());
        ArrayList<String> list = new ArrayList<String>();
        list.add(appId);
        list.add(timeStamp);
        list.add(nonceStr);
        list.add(prepayId);
        String packageSign = PayKit.createSign(PayKit.buildSignMessage(list), privateKey);
        packageParams.put(FIELD_SIGN, packageSign);
        return packageParams;
    }

    public static Map<String, String> miniAppPrepayIdCreateSign(String appId, String prepayId, String partnerKey, SignType signType) {
        HashMap<String, String> packageParams = new HashMap<String, String>(6);
        packageParams.put("appId", appId);
        packageParams.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        packageParams.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("package", "prepay_id=" + prepayId);
        if (signType == null) {
            signType = SignType.MD5;
        }
        packageParams.put("signType", signType.getType());
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, signType);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static String buildAuthorization(RequestMethodEnum method, String urlSuffix, String mchId, String serialNo, String keyPath, String body, String nonceStr, long timestamp, String authType) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(method, urlSuffix, timestamp, nonceStr, body);
        String signature = PayKit.createSign(buildSignMessage, keyPath, authType);
        return PayKit.getAuthorization(mchId, serialNo, nonceStr, String.valueOf(timestamp), signature, authType);
    }

    public static String buildAuthorization(RequestMethodEnum method, String urlSuffix, String mchId, String serialNo, PrivateKey privateKey, String body, String nonceStr, long timestamp, String authType) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(method, urlSuffix, timestamp, nonceStr, body);
        String signature = PayKit.createSign(buildSignMessage, privateKey);
        return PayKit.getAuthorization(mchId, serialNo, nonceStr, String.valueOf(timestamp), signature, authType);
    }

    public static String buildAuthorization(RequestMethodEnum method, String urlSuffix, String mchId, String serialNo, String keyPath, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = AuthTypeEnum.RSA.getCode();
        String nonceStr = PayKit.generateStr();
        return WxPayKit.buildAuthorization(method, urlSuffix, mchId, serialNo, keyPath, body, nonceStr, timestamp, authType);
    }

    public static String buildAuthorization(RequestMethodEnum method, String urlSuffix, String mchId, String serialNo, PrivateKey privateKey, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = AuthTypeEnum.RSA.getCode();
        String nonceStr = PayKit.generateStr();
        return WxPayKit.buildAuthorization(method, urlSuffix, mchId, serialNo, privateKey, body, nonceStr, timestamp, authType);
    }

    @Deprecated
    public static boolean verifySignature(Map<String, Object> map, String certPath) throws Exception {
        String signature = (String)map.get("signature");
        String body = (String)map.get("body");
        String nonceStr = (String)map.get("nonceStr");
        String timestamp = (String)map.get("timestamp");
        String signatureType = (String)map.get("Wechatpay-Signature-Type");
        return WxPayKit.verifySignature(signatureType, signature, body, nonceStr, timestamp, PayKit.getCertFileInputStream(certPath));
    }

    public static boolean verifySignature(IJPayHttpResponse response, String certPath) throws Exception {
        String timestamp = response.getHeader("Wechatpay-Timestamp");
        String nonceStr = response.getHeader("Wechatpay-Nonce");
        String signature = response.getHeader("Wechatpay-Signature");
        String signatureType = response.getHeader("Wechatpay-Signature-Type");
        String body = response.getBody();
        System.out.println("timestamp:" + timestamp);
        System.out.println("nonceStr:" + nonceStr);
        System.out.println("signature:" + signature);
        System.out.println("signatureType:" + signatureType);
        System.out.println("body:" + body);
        return WxPayKit.verifySignature(signatureType, signature, body, nonceStr, timestamp, PayKit.getCertFileInputStream(certPath));
    }

    public static boolean verifySignature(IJPayHttpResponse response, InputStream certInputStream) throws Exception {
        String timestamp = response.getHeader("Wechatpay-Timestamp");
        String nonceStr = response.getHeader("Wechatpay-Nonce");
        String signature = response.getHeader("Wechatpay-Signature");
        String signatureType = response.getHeader("Wechatpay-Signature-Type");
        String body = response.getBody();
        return WxPayKit.verifySignature(signatureType, signature, body, nonceStr, timestamp, certInputStream);
    }

    @Deprecated
    public static boolean verifySignature(Map<String, Object> map, InputStream certInputStream) throws Exception {
        String signature = (String)map.get("signature");
        String body = (String)map.get("body");
        String nonceStr = (String)map.get("nonceStr");
        String timestamp = (String)map.get("timestamp");
        String signatureType = (String)map.get("Wechatpay-Signature-Type");
        return WxPayKit.verifySignature(signatureType, signature, body, nonceStr, timestamp, certInputStream);
    }

    public static boolean verifySignature(String signature, String body, String nonce, String timestamp, String publicKey) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(timestamp, nonce, body);
        return RsaKit.checkByPublicKey(buildSignMessage, signature, publicKey);
    }

    public static boolean verifySignature(String signature, String body, String nonce, String timestamp, PublicKey publicKey) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(timestamp, nonce, body);
        return RsaKit.checkByPublicKey(buildSignMessage, signature, publicKey);
    }

    public static boolean verifySignature(String signatureType, String signature, String body, String nonce, String timestamp, InputStream certInputStream) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(timestamp, nonce, body);
        X509Certificate certificate = PayKit.getCertificate(certInputStream);
        PublicKey publicKey = certificate.getPublicKey();
        if (StrUtil.equals((CharSequence)signatureType, (CharSequence)AuthTypeEnum.SM2.getCode())) {
            return PayKit.sm4Verify(publicKey, buildSignMessage, signature);
        }
        return RsaKit.checkByPublicKey(buildSignMessage, signature, publicKey);
    }

    public static String verifyNotify(String serialNo, String body, String signature, String nonce, String timestamp, String key, InputStream certInputStream) throws Exception {
        X509Certificate certificate = PayKit.getCertificate(certInputStream);
        String serialNumber = certificate.getSerialNumber().toString(16).toUpperCase();
        if (serialNumber.equals(serialNo)) {
            boolean verifySignature = WxPayKit.verifySignature(signature, body, nonce, timestamp, certificate.getPublicKey());
            if (verifySignature) {
                JSONObject resultObject = JSONUtil.parseObj((String)body);
                JSONObject resource = resultObject.getJSONObject((Object)"resource");
                String cipherText = resource.getStr((Object)"ciphertext");
                String nonceStr = resource.getStr((Object)"nonce");
                String associatedData = resource.getStr((Object)"associated_data");
                AesUtil aesUtil = new AesUtil(key.getBytes(StandardCharsets.UTF_8));
                return aesUtil.decryptToString(associatedData.getBytes(StandardCharsets.UTF_8), nonceStr.getBytes(StandardCharsets.UTF_8), cipherText);
            }
            throw new Exception("\u7b7e\u540d\u9519\u8bef");
        }
        throw new Exception("\u8bc1\u4e66\u5e8f\u5217\u53f7\u9519\u8bef");
    }

    public static String verifyNotify(String serialNo, String body, String signature, String nonce, String timestamp, String key, String certPath) throws Exception {
        InputStream inputStream = PayKit.getCertFileInputStream(certPath);
        return WxPayKit.verifyNotify(serialNo, body, signature, nonce, timestamp, key, inputStream);
    }
}

