/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.core.util;

import com.github.xiaoymin.knife4j.core.util.CommonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Knife4jUtils {
    private static final Logger log = LoggerFactory.getLogger(Knife4jUtils.class);

    public static void main(String[] args) {
        System.out.println(Knife4jUtils.GetUrl("http://localhost:17812/v3/api-docs/\u7528\u6237\u6a21\u5757"));
    }

    public static String GetUrl(String url) {
        Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String chinese = matcher.group();
            try {
                String encodedChinese = URLEncoder.encode(chinese, StandardCharsets.UTF_8.name());
                url = url.replace(chinese, encodedChinese);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    public static String postRetry(String url, String body, int retry) {
        for (int i = 0; i < retry; ++i) {
            String result = Knife4jUtils.post(url, body);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getRetry(String url, int retry) {
        for (int i = 0; i < retry; ++i) {
            String result = Knife4jUtils.get(url);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String get(String url) {
        URL apiUrl = null;
        try {
            String realUrl = Knife4jUtils.GetUrl(url);
            log.debug("url:{}", (Object)realUrl);
            apiUrl = new URL(realUrl);
            HttpURLConnection connection = Knife4jUtils.getGetUrlConnection(apiUrl);
            String response = Knife4jUtils.getEntity(connection);
            if (response != null) {
                return response;
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String getEntity(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            CommonUtils.close(in);
            return response.toString();
        }
        return null;
    }

    public static String post(String url, String body) {
        URL apiUrl = null;
        try {
            log.debug("url:{}", (Object)url);
            log.debug("body:{}", (Object)body);
            apiUrl = new URL(url);
            HttpURLConnection connection = Knife4jUtils.getUrlConnection(apiUrl);
            OutputStream os = connection.getOutputStream();
            os.write(body.getBytes());
            CommonUtils.close(os);
            String response = Knife4jUtils.getEntity(connection);
            if (response != null) {
                return response;
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static HttpURLConnection getUrlConnection(URL apiUrl) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)apiUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
        Knife4jUtils.setConnection(connection);
        return connection;
    }

    private static HttpURLConnection getGetUrlConnection(URL apiUrl) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)apiUrl.openConnection();
        connection.setRequestMethod("GET");
        Knife4jUtils.setConnection(connection);
        return connection;
    }

    private static void setConnection(HttpURLConnection connection) {
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("User-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setReadTimeout(20000);
        connection.setConnectTimeout(20000);
    }
}

