/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.nlp;

import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.nlp.TextAnalysis;
import com.xkzhangsan.time.nlp.TextPreprocess;
import com.xkzhangsan.time.nlp.TimeContext;
import com.xkzhangsan.time.nlp.TimeNLP;
import com.xkzhangsan.time.nlp.TimeNLPCallable;
import com.xkzhangsan.time.utils.CollectionUtil;
import com.xkzhangsan.time.utils.GlobalThreadPool;
import com.xkzhangsan.time.utils.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeNLPUtil {
    private TimeNLPUtil() {
    }

    public static List<TimeNLP> parse(String text) {
        return TimeNLPUtil.parse(text, null);
    }

    public static List<TimeNLP> parseConcurrent(String text) throws InterruptedException, ExecutionException, TimeoutException {
        return TimeNLPUtil.parse(text, null, 0L, null, null);
    }

    public static List<TimeNLP> parseConcurrentDefaultTime(String text) throws InterruptedException, ExecutionException, TimeoutException {
        return TimeNLPUtil.parse(text, null, 3000L, TimeUnit.MILLISECONDS, null);
    }

    public static List<TimeNLP> parseConcurrent(String text, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return TimeNLPUtil.parse(text, null, timeout, unit, null);
    }

    public static List<TimeNLP> parseConcurrent(String text, long timeout, TimeUnit unit, ExecutorService executorService) throws InterruptedException, ExecutionException, TimeoutException {
        return TimeNLPUtil.parse(text, null, timeout, unit, executorService);
    }

    public static List<TimeNLP> parse(String text, String timeBase) {
        if (StringUtil.isEmpty(text)) {
            return null;
        }
        if (StringUtil.isEmpty(text = TextPreprocess.preprocess(text))) {
            return null;
        }
        List<String> timeStrs = TextAnalysis.getInstance().analysis(text);
        if (CollectionUtil.isEmpty(timeStrs)) {
            return null;
        }
        ArrayList<TimeNLP> timeNLPList = new ArrayList<TimeNLP>(timeStrs.size());
        TimeContext timeContext = new TimeContext();
        if (StringUtil.isEmpty(timeBase)) {
            timeBase = DateTimeFormatterUtil.format(new Date(), "yyyy-MM-dd-HH-mm-ss");
        }
        String oldTimeBase = timeBase;
        timeContext.setTimeBase(timeBase);
        timeContext.setOldTimeBase(oldTimeBase);
        for (int j = 0; j < timeStrs.size() && !StringUtil.isEmpty(timeStrs.get(j)); ++j) {
            TimeNLP timeNLP = new TimeNLP(timeStrs.get(j), TextAnalysis.getInstance(), timeContext);
            timeNLPList.add(timeNLP);
            timeContext = timeNLP.getTimeContext();
        }
        List<TimeNLP> timeNLPListResult = TimeNLP.filterTimeUnit(timeNLPList);
        return timeNLPListResult;
    }

    public static List<TimeNLP> parse(String text, String timeBase, long timeout, TimeUnit unit, ExecutorService executorService) throws InterruptedException, ExecutionException, TimeoutException {
        List<TimeNLP> result = null;
        if (StringUtil.isEmpty(text)) {
            return result;
        }
        result = timeout > 0L ? (executorService != null ? executorService.submit(new TimeNLPCallable(text, timeBase)).get(timeout, unit) : GlobalThreadPool.getGlobalThreadPool().submit(new TimeNLPCallable(text, timeBase)).get(timeout, unit)) : (executorService != null ? executorService.submit(new TimeNLPCallable(text, timeBase)).get() : GlobalThreadPool.getGlobalThreadPool().submit(new TimeNLPCallable(text, timeBase)).get());
        return result;
    }
}

