/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.injection.core;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.injection.annonation.InjectionField;
import com.github.zuihou.injection.core.FieldParam;
import com.github.zuihou.injection.core.InjectionFieldExtPo;
import com.github.zuihou.injection.core.InjectionFieldPo;
import com.github.zuihou.injection.properties.InjectionProperties;
import com.github.zuihou.jackson.JsonUtil;
import com.github.zuihou.model.RemoteData;
import com.github.zuihou.utils.SpringUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionCore {
    private static final Logger log = LoggerFactory.getLogger(InjectionCore.class);
    private final InjectionProperties ips;
    private ListeningExecutorService backgroundRefreshPools;
    private LoadingCache<InjectionFieldExtPo, Map<Serializable, Object>> caches;

    public InjectionCore(InjectionProperties ips) {
        this.ips = ips;
        InjectionProperties.GuavaCache guavaCache = ips.getGuavaCache();
        if (guavaCache.getEnabled().booleanValue()) {
            this.backgroundRefreshPools = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(guavaCache.getRefreshThreadPoolSize(), guavaCache.getRefreshThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
            this.caches = CacheBuilder.newBuilder().maximumSize((long)guavaCache.getMaximumSize().intValue()).refreshAfterWrite((long)guavaCache.getRefreshWriteTime().intValue(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<InjectionFieldExtPo, Map<Serializable, Object>>(){

                public Map<Serializable, Object> load(InjectionFieldExtPo type) throws Exception {
                    log.info("\u9996\u6b21\u8bfb\u53d6\u7f13\u5b58: " + type);
                    return InjectionCore.this.loadMap(type);
                }

                public ListenableFuture<Map<Serializable, Object>> reload(InjectionFieldExtPo key, Map<Serializable, Object> oldValue) throws Exception {
                    return InjectionCore.this.backgroundRefreshPools.submit(() -> {
                        BaseContextHandler.setTenant((String)key.getTenant());
                        return this.load(key);
                    });
                }
            });
        }
    }

    private Map<Serializable, Object> loadMap(InjectionFieldExtPo type) {
        Object bean = null;
        if (StrUtil.isNotEmpty((CharSequence)type.getApi())) {
            bean = SpringUtils.getBean((String)type.getApi());
            log.info("\u5efa\u8bae\u5728\u65b9\u6cd5\uff1a [{}.{}]\uff0c\u4e0a\u52a0\u5165\u7f13\u5b58\uff0c\u52a0\u901f\u67e5\u8be2", (Object)type.getApi(), (Object)type.getMethod());
        } else {
            bean = SpringUtils.getBean(type.getApiClass());
            log.info("\u5efa\u8bae\u5728\u65b9\u6cd5\uff1a [{}.{}]\uff0c\u4e0a\u52a0\u5165\u7f13\u5b58\uff0c\u52a0\u901f\u67e5\u8be2", (Object)type.getApiClass().toString(), (Object)type.getMethod());
        }
        Map value = (Map)ReflectUtil.invoke((Object)bean, (String)type.getMethod(), (Object[])new Object[]{type.getKeys()});
        return value;
    }

    public void injection(Object obj, boolean isUseCache) {
        try {
            HashMap<InjectionFieldPo, Map<Serializable, Object>> typeMap = new HashMap<InjectionFieldPo, Map<Serializable, Object>>();
            long parseStart = System.currentTimeMillis();
            this.parse(obj, typeMap, 1);
            long parseEnd = System.currentTimeMillis();
            log.info("\u89e3\u6790\u8017\u65f6={} ms", (Object)(parseEnd - parseStart));
            if (typeMap.isEmpty()) {
                return;
            }
            for (Map.Entry entries : typeMap.entrySet()) {
                InjectionFieldPo type = (InjectionFieldPo)entries.getKey();
                Map valueMap = (Map)entries.getValue();
                Set<Serializable> keys = valueMap.keySet();
                try {
                    InjectionFieldExtPo extPo = new InjectionFieldExtPo(type, keys);
                    Map value = this.ips.getGuavaCache().getEnabled() != false && isUseCache ? (Map)this.caches.get((Object)extPo) : this.loadMap(extPo);
                    typeMap.put(type, value);
                }
                catch (Exception e) {
                    log.error("\u8fdc\u7a0b\u8c03\u7528\u65b9\u6cd5 [{}({}).{}] \u5931\u8d25\uff0c \u8bf7\u786e\u4fdd\u7cfb\u7edf\u5b58\u5728\u8be5\u65b9\u6cd5", new Object[]{type.getApi(), type.getApiClass().toString(), type.getMethod(), e});
                }
            }
            long injectionStart = System.currentTimeMillis();
            log.info("\u6279\u91cf\u67e5\u8be2\u8017\u65f6={} ms", (Object)(injectionStart - parseEnd));
            this.injection(obj, typeMap, 1);
            long injectionEnd = System.currentTimeMillis();
            log.info("\u6ce8\u5165\u8017\u65f6={} ms", (Object)(injectionEnd - injectionStart));
        }
        catch (Exception e) {
            log.warn("\u6ce8\u5165\u5931\u8d25", (Throwable)e);
        }
    }

    public void injection(Object obj) {
        this.injection(obj, true);
    }

    private boolean isNotBaseType(Object obj, Field field) {
        String typeName = field.getType().getName();
        return !"java.lang.Integer".equals(typeName) && !"java.lang.Byte".equals(typeName) && !"java.lang.Long".equals(typeName) && !"java.lang.Double".equals(typeName) && !"java.lang.Float".equals(typeName) && !"java.lang.Character".equals(typeName) && !"java.lang.Short".equals(typeName) && !"java.lang.Boolean".equals(typeName) && !"java.lang.String".equals(typeName) && !"com.github.zuihou.model.RemoteData".equals(typeName);
    }

    private void parse(Object obj, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, int depth) {
        Field[] fields;
        if (obj == null) {
            return;
        }
        if (depth > this.ips.getMaxDepth()) {
            log.info("\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\uff0c\u6700\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)this.ips.getMaxDepth(), (Object)depth);
            return;
        }
        if (typeMap == null) {
            typeMap = new HashMap<InjectionFieldPo, Map<Serializable, Object>>();
        }
        if (obj instanceof IPage) {
            List records = ((IPage)obj).getRecords();
            this.parseList(records, typeMap, depth);
            return;
        }
        if (obj instanceof Collection) {
            this.parseList((Collection)obj, typeMap, depth);
            return;
        }
        for (Field field : fields = ReflectUtil.getFields(obj.getClass())) {
            FieldParam fieldParam = this.getFieldParam(obj, field, typeMap, innerTypeMap -> this.parse(ReflectUtil.getFieldValue((Object)obj, (Field)field), (Map<InjectionFieldPo, Map<Serializable, Object>>)innerTypeMap, depth + 1));
            if (fieldParam == null) continue;
            InjectionFieldPo type = new InjectionFieldPo(fieldParam.getAnno());
            Map valueMap = typeMap.getOrDefault(type, new HashMap());
            valueMap.put(fieldParam.getQueryKey(), null);
            typeMap.put(type, valueMap);
        }
    }

    private void parseList(Collection list, Map typeMap, int depth) {
        for (Object item : list) {
            this.parse(item, typeMap, depth);
        }
    }

    private void injection(Object obj, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, int depth) {
        Field[] fields;
        if (obj == null) {
            return;
        }
        if (depth > this.ips.getMaxDepth()) {
            log.info("\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\uff0c\u6700\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)this.ips.getMaxDepth(), (Object)depth);
            return;
        }
        if (typeMap == null || typeMap.isEmpty()) {
            return;
        }
        if (obj instanceof IPage) {
            List records = ((IPage)obj).getRecords();
            this.injectionList(records, typeMap);
            return;
        }
        if (obj instanceof Collection) {
            this.injectionList((Collection)obj, typeMap);
            return;
        }
        for (Field field : fields = ReflectUtil.getFields(obj.getClass())) {
            FieldParam fieldParam = this.getFieldParam(obj, field, typeMap, innerTypeMap -> this.injection(ReflectUtil.getFieldValue((Object)obj, (Field)field), (Map<InjectionFieldPo, Map<Serializable, Object>>)innerTypeMap, depth + 1));
            if (fieldParam == null) continue;
            InjectionField anno = fieldParam.getAnno();
            Serializable queryKey = fieldParam.getQueryKey();
            Object curField = fieldParam.getCurField();
            InjectionFieldPo type = new InjectionFieldPo(anno);
            Map<Serializable, Object> valueMap = typeMap.get(type);
            if (valueMap == null || valueMap.isEmpty()) continue;
            Object newVal = valueMap.get(queryKey);
            if (ObjectUtil.isNull((Object)newVal) && ObjectUtil.isNotEmpty((Object)queryKey)) {
                newVal = valueMap.get(queryKey.toString());
            }
            if (curField instanceof RemoteData) {
                RemoteData remoteData = (RemoteData)curField;
                if (newVal != null && newVal instanceof Map && !Object.class.equals(type.getBeanClass())) {
                    newVal = JsonUtil.parse((String)JsonUtil.toJson((Object)newVal), type.getBeanClass());
                }
                remoteData.setData(newVal);
                continue;
            }
            ReflectUtil.setFieldValue((Object)obj, (Field)field, (Object)newVal);
        }
    }

    private void injectionList(Collection list, Map typeMap) {
        for (Object item : list) {
            this.injection(item, typeMap, 1);
        }
    }

    private FieldParam getFieldParam(Object obj, Field field, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, Consumer<Map<InjectionFieldPo, Map<Serializable, Object>>> consumer) {
        InjectionField anno = field.getDeclaredAnnotation(InjectionField.class);
        if (anno == null) {
            return null;
        }
        field.setAccessible(true);
        if (this.isNotBaseType(obj, field)) {
            consumer.accept(typeMap);
            return null;
        }
        String api = anno.api();
        Class<? extends Object> feign = anno.apiClass();
        if (StrUtil.isEmpty((CharSequence)api) && Object.class.equals(feign)) {
            log.warn("\u5ffd\u7565\u6ce8\u5165\u5b57\u6bb5: {}.{}", field.getType(), (Object)field.getName());
            return null;
        }
        Object curField = ReflectUtil.getFieldValue((Object)obj, (Field)field);
        if (curField == null) {
            log.debug("\u5b57\u6bb5[{}]\u4e3a\u7a7a,\u8df3\u8fc7", (Object)field.getName());
            return null;
        }
        Serializable queryKey = this.getQueryKey(anno, curField);
        if (ObjectUtil.isEmpty((Object)queryKey)) {
            return null;
        }
        return new FieldParam(anno, queryKey, curField);
    }

    private Serializable getQueryKey(InjectionField anno, Object curField) {
        Object queryKey;
        String key = anno.key();
        String dictType = anno.dictType();
        if (StrUtil.isNotEmpty((CharSequence)key)) {
            queryKey = key;
        } else if (curField instanceof RemoteData) {
            RemoteData remoteData = (RemoteData)curField;
            queryKey = (Serializable)remoteData.getKey();
        } else {
            queryKey = (Serializable)curField;
        }
        if (ObjectUtil.isNotEmpty((Object)queryKey) && StrUtil.isNotEmpty((CharSequence)dictType)) {
            queryKey = StrUtil.join((CharSequence)this.ips.getDictSeparator(), (Object[])new Object[]{dictType, queryKey});
        }
        return queryKey;
    }
}

