/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SchemeTypeBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.googlecode.mp4parser.authoring.Mp4TrackImpl;
import com.googlecode.mp4parser.authoring.tracks.CencEncryptedTrack;
import com.googlecode.mp4parser.util.Path;
import com.mp4parser.iso14496.part12.SampleAuxiliaryInformationOffsetsBox;
import com.mp4parser.iso14496.part12.SampleAuxiliaryInformationSizesBox;
import com.mp4parser.iso23001.part7.CencSampleAuxiliaryDataFormat;
import com.mp4parser.iso23001.part7.TrackEncryptionBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CencMp4TrackImplImpl
extends Mp4TrackImpl
implements CencEncryptedTrack {
    private List<CencSampleAuxiliaryDataFormat> sampleEncryptionEntries;
    private UUID defaultKeyId;

    public CencMp4TrackImplImpl(String name, TrackBox trackBox, IsoFile ... fragments) throws IOException {
        super(name, trackBox, fragments);
        SchemeTypeBox schm = (SchemeTypeBox)Path.getPath(trackBox, "mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schm[0]");
        assert (schm != null && (schm.getSchemeType().equals("cenc") || schm.getSchemeType().equals("cbc1"))) : "Track must be CENC (cenc or cbc1) encrypted";
        this.sampleEncryptionEntries = new ArrayList<CencSampleAuxiliaryDataFormat>();
        long trackId = trackBox.getTrackHeaderBox().getTrackId();
        if (trackBox.getParent().getBoxes(MovieExtendsBox.class).size() > 0) {
            for (MovieFragmentBox movieFragmentBox : ((Box)((Object)trackBox.getParent())).getParent().getBoxes(MovieFragmentBox.class)) {
                List<TrackFragmentBox> trafs = movieFragmentBox.getBoxes(TrackFragmentBox.class);
                for (TrackFragmentBox traf : trafs) {
                    long baseOffset;
                    Container base;
                    if (traf.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
                    TrackEncryptionBox tenc = (TrackEncryptionBox)Path.getPath(trackBox, "mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/tenc[0]");
                    this.defaultKeyId = tenc.getDefault_KID();
                    if (traf.getTrackFragmentHeaderBox().hasBaseDataOffset()) {
                        base = ((Box)((Object)trackBox.getParent())).getParent();
                        baseOffset = traf.getTrackFragmentHeaderBox().getBaseDataOffset();
                    } else {
                        base = movieFragmentBox;
                        baseOffset = 0L;
                    }
                    FindSaioSaizPair saizSaioPair = new FindSaioSaizPair(traf).invoke();
                    SampleAuxiliaryInformationOffsetsBox saio = saizSaioPair.getSaio();
                    SampleAuxiliaryInformationSizesBox saiz = saizSaioPair.getSaiz();
                    assert (saio != null);
                    long[] saioOffsets = saio.getOffsets();
                    assert (saioOffsets.length == traf.getBoxes(TrackRunBox.class).size());
                    assert (saiz != null);
                    List<TrackRunBox> truns = traf.getBoxes(TrackRunBox.class);
                    int sampleNo = 0;
                    int i = 0;
                    while (i < saioOffsets.length) {
                        int numSamples = truns.get(i).getEntries().size();
                        long offset = saioOffsets[i];
                        long length = 0L;
                        int j = sampleNo;
                        while (j < sampleNo + numSamples) {
                            length += (long)saiz.getSize(j);
                            ++j;
                        }
                        ByteBuffer trunsCencSampleAuxData = base.getByteBuffer(baseOffset + offset, length);
                        int j2 = sampleNo;
                        while (j2 < sampleNo + numSamples) {
                            short auxInfoSize = saiz.getSize(j2);
                            this.sampleEncryptionEntries.add(this.parseCencAuxDataFormat(tenc.getDefaultIvSize(), trunsCencSampleAuxData, auxInfoSize));
                            ++j2;
                        }
                        sampleNo += numSamples;
                        ++i;
                    }
                }
            }
        } else {
            TrackEncryptionBox tenc = (TrackEncryptionBox)Path.getPath(trackBox, "mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/tenc[0]");
            this.defaultKeyId = tenc.getDefault_KID();
            ChunkOffsetBox chunkOffsetBox = (ChunkOffsetBox)Path.getPath(trackBox, "mdia[0]/minf[0]/stbl[0]/stco[0]");
            if (chunkOffsetBox == null) {
                chunkOffsetBox = (ChunkOffsetBox)Path.getPath(trackBox, "mdia[0]/minf[0]/stbl[0]/co64[0]");
            }
            long[] chunkSizes = trackBox.getSampleTableBox().getSampleToChunkBox().blowup(chunkOffsetBox.getChunkOffsets().length);
            FindSaioSaizPair saizSaioPair = new FindSaioSaizPair((Container)Path.getPath(trackBox, "mdia[0]/minf[0]/stbl[0]")).invoke();
            SampleAuxiliaryInformationOffsetsBox saio = saizSaioPair.saio;
            SampleAuxiliaryInformationSizesBox saiz = saizSaioPair.saiz;
            Container topLevel = ((MovieBox)trackBox.getParent()).getParent();
            if (saio.getOffsets().length == 1) {
                long offset = saio.getOffsets()[0];
                int sizeInTotal = 0;
                if (saiz.getDefaultSampleInfoSize() > 0) {
                    sizeInTotal += saiz.getSampleCount() * saiz.getDefaultSampleInfoSize();
                } else {
                    int i = 0;
                    while (i < saiz.getSampleCount()) {
                        sizeInTotal += saiz.getSampleInfoSizes()[i];
                        ++i;
                    }
                }
                ByteBuffer chunksCencSampleAuxData = topLevel.getByteBuffer(offset, sizeInTotal);
                int i = 0;
                while (i < saiz.getSampleCount()) {
                    this.sampleEncryptionEntries.add(this.parseCencAuxDataFormat(tenc.getDefaultIvSize(), chunksCencSampleAuxData, saiz.getSize(i)));
                    ++i;
                }
            } else if (saio.getOffsets().length == chunkSizes.length) {
                int currentSampleNo = 0;
                int i = 0;
                while (i < chunkSizes.length) {
                    long offset = saio.getOffsets()[i];
                    long size = 0L;
                    if (saiz.getDefaultSampleInfoSize() > 0) {
                        size += (long)saiz.getSampleCount() * chunkSizes[i];
                    } else {
                        int j = 0;
                        while ((long)j < chunkSizes[i]) {
                            size += (long)saiz.getSize(currentSampleNo + j);
                            ++j;
                        }
                    }
                    ByteBuffer chunksCencSampleAuxData = topLevel.getByteBuffer(offset, size);
                    int j = 0;
                    while ((long)j < chunkSizes[i]) {
                        long auxInfoSize = saiz.getSize(currentSampleNo + j);
                        this.sampleEncryptionEntries.add(this.parseCencAuxDataFormat(tenc.getDefaultIvSize(), chunksCencSampleAuxData, auxInfoSize));
                        ++j;
                    }
                    currentSampleNo = (int)((long)currentSampleNo + chunkSizes[i]);
                    ++i;
                }
            } else {
                throw new RuntimeException("Number of saio offsets must be either 1 or number of chunks");
            }
        }
    }

    private CencSampleAuxiliaryDataFormat parseCencAuxDataFormat(int ivSize, ByteBuffer chunksCencSampleAuxData, long auxInfoSize) {
        CencSampleAuxiliaryDataFormat cadf = new CencSampleAuxiliaryDataFormat();
        if (auxInfoSize > 0L) {
            cadf.iv = new byte[ivSize];
            chunksCencSampleAuxData.get(cadf.iv);
            if (auxInfoSize > (long)ivSize) {
                int numOfPairs = IsoTypeReader.readUInt16(chunksCencSampleAuxData);
                cadf.pairs = new CencSampleAuxiliaryDataFormat.Pair[numOfPairs];
                int i = 0;
                while (i < cadf.pairs.length) {
                    cadf.pairs[i] = cadf.createPair(IsoTypeReader.readUInt16(chunksCencSampleAuxData), IsoTypeReader.readUInt32(chunksCencSampleAuxData));
                    ++i;
                }
            }
        }
        return cadf;
    }

    @Override
    public UUID getDefaultKeyId() {
        return this.defaultKeyId;
    }

    @Override
    public boolean hasSubSampleEncryption() {
        return false;
    }

    @Override
    public List<CencSampleAuxiliaryDataFormat> getSampleEncryptionEntries() {
        return this.sampleEncryptionEntries;
    }

    public String toString() {
        return "CencMp4TrackImpl{handler='" + this.getHandler() + '\'' + '}';
    }

    @Override
    public String getName() {
        return "enc(" + super.getName() + ")";
    }

    private class FindSaioSaizPair {
        private Container container;
        private SampleAuxiliaryInformationSizesBox saiz;
        private SampleAuxiliaryInformationOffsetsBox saio;

        public FindSaioSaizPair(Container container) {
            this.container = container;
        }

        public SampleAuxiliaryInformationSizesBox getSaiz() {
            return this.saiz;
        }

        public SampleAuxiliaryInformationOffsetsBox getSaio() {
            return this.saio;
        }

        public FindSaioSaizPair invoke() {
            List<SampleAuxiliaryInformationSizesBox> saizs = this.container.getBoxes(SampleAuxiliaryInformationSizesBox.class);
            List<SampleAuxiliaryInformationOffsetsBox> saios = this.container.getBoxes(SampleAuxiliaryInformationOffsetsBox.class);
            assert (saizs.size() == saios.size());
            this.saiz = null;
            this.saio = null;
            int i = 0;
            while (i < saizs.size()) {
                if (this.saiz == null && saizs.get(i).getAuxInfoType() == null || "cenc".equals(saizs.get(i).getAuxInfoType())) {
                    this.saiz = saizs.get(i);
                } else if (this.saiz != null && this.saiz.getAuxInfoType() == null && "cenc".equals(saizs.get(i).getAuxInfoType())) {
                    this.saiz = saizs.get(i);
                } else {
                    throw new RuntimeException("Are there two cenc labeled saiz?");
                }
                if (this.saio == null && saios.get(i).getAuxInfoType() == null || "cenc".equals(saios.get(i).getAuxInfoType())) {
                    this.saio = saios.get(i);
                } else if (this.saio != null && this.saio.getAuxInfoType() == null && "cenc".equals(saios.get(i).getAuxInfoType())) {
                    this.saio = saios.get(i);
                } else {
                    throw new RuntimeException("Are there two cenc labeled saio?");
                }
                ++i;
            }
            return this;
        }
    }
}

